<?php

function badges_process_commands($cmd,$opts)
{
  switch( $cmd ) {
  case 'LIST':
    return badges_list($opts);
  case 'GET':
    return badges_get($opts);
  case 'LEADERS':
    return badges_members($opts);
  }
}

function badges_list($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: list
list badges
EOT;
  }

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/badges');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','LIST');

  $res = $req->execute();
  print_r($res); echo "\n";

  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function badges_get($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
echo <<<EOT
usage: get id
get information for one badge.
EOT;
  }

  if( count($opts) != 1 ) {
    set_errormsg('badges_get: Missing badge id param');
    return FALSE;
  }
  $the_id = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/badges');
  $req->addParam('op','GET');
  $req->addParam('apikey',_apikey());
  $req->addParam('badge',$the_id);

  $res = $req->execute();
  print_r($res);
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


function leaderboards_members($opts)
{
  if( count($opts) == 1 && strtolower($opts[0]) == 'help' ) {
    echo <<<EOT
usage: leaders id [n [o]]
retrieve member information for a badge
EOT;
  }

  if( count($opts) < 1 ) {
    set_errormsg('leaderboards_get: Missing leaderboard id param');
    return FALSE;
  }
  if( count($opts) > 3 ) {
    set_errormsg('leaderboards_get: too manu arguments');
    return FALSE;
  }
  $the_id = (int)$opts[0];

  $req = new cms_http_request();
  $req->setTarget(BASE_URL.'/leaderboards');
  $req->addParam('apikey',_apikey());
  $req->addParam('op','MEMBERS');
  $req->addParam('badge',$the_id);
  if( isset($opts[1]) ) {
    $req->addParam('n',(int)$opts[1]);
  }
  if( isset($opts[2]) ) {
    $req->addParam('o',(int)$opts[2]);
  }

  $res = $req->execute();
  $tmp = json_decode($res,TRUE);
  if( isset($tmp->_status) && $tmp->_status != 'OK' ) {
    $msg = $tmp->_status;
    if( isset($tmp->_message) ) {
      $msg .= ': '.$tmp->_message;
    }
    set_errormsg($msg);
    return FALSE;
  }

  print_r($tmp); // woot done.
  return TRUE;
}


#
# EOF
#
?>
