<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) {
  $op = strtoupper(trim($_REQUEST['op']));
}
if( isset($_REQUEST['apikey']) ) {
  $apikey = trim($_REQUEST['apikey']);
}

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) {
  cgsa_utils::return_error('Invalid authentication information');
}

switch( $op ) {
 case 'LIST':
   // list all activities as a tree.
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LEADERBOARDS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   $output = cgsa_leaderboard::get_all(FALSE);
   break;

 case 'GET':
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LEADERBOARDS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !isset($_REQUEST['board']) ) cgsa_utils::return_error('Insufficient data');
   $lid = (int)$_REQUEST['board'];
   $tmp = cgsa_leaderboard::load_by_id($lid,FALSE);
   if( !is_array($tmp) ) cgsa_utils::return_error('Data not found');
   $output = $tmp;
   break;
   
 case 'BADGES':
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LEADERBOARDS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !isset($_REQUEST['board']) ) cgsa_utils::return_error('Insufficient data');
   $lid = (int)$_REQUEST['board'];
   $tmp = cgsa_leaderboard::load_by_id($lid);
   if( !is_object($tmp) ) cgsa_utils::return_error('Data not found');
   $output = $tmp->get_badges(FALSE);
   break;
   
 case 'LEADERS':
   if( !cgsa_utils::is_get_request() ) return_error('Invalid request method');
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_LEADERBOARDS_READ) ||
       !$access_info->check_permission(cgsa_apikey_perms::PERM_USERS_READ) ) {
     cgsa_utils::return_error('Insufficient Permissions');
   }
   if( !isset($_REQUEST['board']) ) cgsa_utils::return_error('Insufficient data');
   $limit = 25;
   $offset = 0;
   $lid = (int)$_REQUEST['board'];
   if( isset($_REQUEST['n']) ) $limit = max(1,(int)$params['l']);
   if( isset($_REQUEST['o']) ) $offset = max(1,(int)$params['o']);
   $board = cgsa_leaderboard::load_by_id($lid);
   if( !is_object($board) ) cgsa_utils::return_error('Data not found');
   $output = $board->get_leaders($limit,$offset);
   break;
   
 default:
   cgsa_utils::return_error('Unknown command');
}

cgsa_utils::return_success($output);

#
# EOF
#
?>