<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';

//
// setup
//
if( isset($_REQUEST['op'] ) ) {
  $op = strtoupper(trim($_REQUEST['op']));
}
if( isset($_REQUEST['apikey']) ) {
  $apikey = trim($_REQUEST['apikey']);
}

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) {
  cgsa_utils::return_error('Invalid authentication information');
}

//
// handle the request
switch( $op ) {
 case 'LIST':  // GET REQUEST
   // list friends 
   if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_READ) )
     cgsa_utils::return_error('Insufficient Permissions');
   if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
   if( !isset($_REQUEST['uid']) )
     cgsa_utils::return_error('Insufficient data');
   $feu = cge_utils::get_module('FrontEndUsers');
   if( !$feu ) cgsa_utils::return_error('Internal error');
   $tuid = $feu->LoggedInId();
   $uid = (int)$_REQUEST['uid'];
   if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
   $limit = 100000;
   $offset = 0;
   $deep = 0;
   if( isset($_REQUEST['n']) )  $limit = max(1,(int)$_REQUEST['n']);
   if( isset($_REQUEST['o']) ) $offset = max(0,(int)$_REQUEST['o']);
   if( isset($_REQUEST['deep']) ) $deep = (int)$_REQUEST['deep'];
   $output = cgsa_friends::get_friends($uid,$limit,$offset);
   if( is_array($output) && count($output) && $deep ) {
     // gotta get the usernames that match all of these uids.
     $query = new feu_user_query(10000);
     $query->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$output);
     $urs = $query->execute();
     $user_list = array();
     while( !$urs->EOF ) {
       $user_list[] = array('uid'=>$urs->fields['id'],'username'=>$urs->fields['username']);
       $urs->MoveNext();
     }
     $output = $user_list;
   }
   break;

  case 'DEL':
  case 'REMOVE': // POST REQUEST
    // delete a friend
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_WRITE) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) || !isset($_REQUEST['fuid']) )
      cgsa_utils::return_error('Insufficient data');
    $uid = trim($_REQUEST['uid']);
    $fuid = trim($_REQUEST['fuid']);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    // todo: check if this fuid is valid.
    cgsa_friends::remove_friendship($uid,$fuid);
    break;

  case 'SUGGEST': // GET REQUEST
    // suggest more friends.
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_READ) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) )
      cgsa_utils::return_error('Insufficient data');
    $uid = trim($_REQUEST['uid']);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    $output = cgsa_friends::suggest($uid);
    break;

  case 'REQUESTLIST': // GET request
    // list friend requests for a user.
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_READ) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) )
      cgsa_utils::return_error('Insufficient data');
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    $uid = (int)$_REQUEST['uid'];
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    $limit = 100000;
    $offset = 0;
    if( isset($_REQUEST['n']) ) $limit = max(1,(int)$_REQUEST['n']);
    if( isset($_REQUEST['o']) )$offset = max(0,(int)$_REQUEST['o']);
    $output = cgsa_friends::get_friendrequests($uid,$limit,$offset);
    break;

  case 'REQUEST': // post
    // send a friend request
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_WRITE) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) || !isset($_REQUEST['fuid']) )
      cgsa_utils::return_error('Insufficient data');
    $uid = trim($_REQUEST['uid']);
    $fuid = trim($_REQUEST['fuid']);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    cgsa_friends::create_friendrequest($fuid,$uid);
    break;

  case 'APPROVE': // POST REQUEST
    // approve a friend request
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_WRITE) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) || !isset($_REQUEST['fuid']) )
      cgsa_utils::return_error('Insufficient data');
    $uid = trim($_REQUEST['uid']);
    $fuid = trim($_REQUEST['fuid']);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    cgsa_friends::approve_friendrequest($uid,$fuid);
    break;

  case 'DENY': // POST REQUEST
    // deny a friend request
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_WRITE) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) || !isset($_REQUEST['fuid']) )
      cgsa_utils::return_error('Insufficient data');
    $uid = trim($_REQUEST['uid']);
    $fuid = trim($_REQUEST['fuid']);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid got $uid, but expected $tuid");
    cgsa_friends::deny_friendrequest($uid,$fuid);
    break;
    
  default:
    cgsa_utils::return_error("Unknown comman $op");
  }

cgsa_utils::return_success($output);

#
# EOF
#
?>