<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$apikey = '';
$op = '';
$output = null;

//
// setup
//
if( isset($_REQUEST['op'] ) ) {
  $op = strtoupper(trim($_REQUEST['op']));
}
if( isset($_REQUEST['apikey']) ) {
  $apikey = trim($_REQUEST['apikey']);
}

// dependency check.
$cdmod = cms_utils::get_module('CompanyDirectory');
if( !$cdmod ) cgsa_utils::return_error('CompanyDirectory module not found');

// validation check
if( $apikey == '' ) cgsa_utils::return_error('No Authentication Information');
if( $op == '' ) cgsa_utils::return_error('Operation not specified');

// validate the apikey.
$access_info = cgsa_utils::validate_apikey($apikey);
if( !is_object($access_info) ) {
  cgsa_utils::return_error('Invalid authentication information');
}

// 
// handle the request
//
switch( $op ) {
  case 'ADD': // POST REQUEST
    // add a single checkin
    try {
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_ADD) )
	throw new Exception('Insufficient Permissions');

      if( !cgsa_utils::is_post_request() )
	throw new Exception('Invalid request method');

      if( !isset($_REQUEST['owner']) || !isset($_REQUEST['location']) || !isset($_REQUEST['msg']) )
	throw new Exception('Insufficient data');
	
      $feu = cge_utils::get_module('FrontEndUsers');
      if( !$feu ) cgsa_utils::return_error('Internal error');
      $uid = $feu->LoggedInId();
      $owner = (int)$_REQUEST['owner'];
      if( $uid != $owner ) 
	throw new Exception("Invalid owner got $owner, but expected $uid");

      $checkin = new cgsa_checkin;
      $checkin->owner = $owner;
      if( isset($_REQUEST['location']) ) {
	$checkin->location = (int)$_REQUEST['location'];
      }
      if( isset($_REQUEST['activity']) ) {
	$checkin->activity = (int)$_REQUEST['activity'];
      }
      if( isset($_REQUEST['parent_id']) ) {
	$checkin->parent_id = (int)$_REQUEST['parent_id'];
      }
      if( isset($_REQUEST['msg']) ) {
	$checkin->msg = substr(trim($_REQUEST['msg']),0,255);
      }
      if( isset($_REQUEST['lat']) && isset($_REQUEST['lng']) ) {
	$checkin->lat = (float)$_REQUEST['lat'];
	$checkin->lng = (float)$_REQUEST['lng'];
      }
      if( isset($_REQUEST['tag']) && !empty($_REQUEST['tag']) ) {
	// maybe we should have some limiting here?
	// can we tag anybody, or just friends?
	$checkin->tag_user($_REQUEST['tag']);
      }
      foreach( $_REQUEST as $key => $value ) {
	if( startswith($key,'extra_') ) {
	  $key = trim($key);
	  $checkin->$key = $value;
	}
      }

      // validate the location
      $company = cd_utils::get_company($checkin->location);
      if( !$company )
	throw new Exception('Location '.$checkin->location.' not found');

      if( $company->status != 'published' )
	throw new Exception('Location '.$checkin->location.' has an invalid status');

      // is approval needed.
      $checkin->approved = 0;
      if( !cgsa_utils::is_checkin_approval_required($checkin->location) ) {
	$checkin->approved = 1;
      }

      // do ratelimiting.
      if( $cdmod->GetPreference('locationrequired',0) && !isset($checkin->lat) )
	throw new Exception('Missing required source coordinate information');
	
      if( ($tmp = $cdmod->GetPreference('checkinratelimiting')) ) {
	$rl = explode(',',$tmp);
	if( in_array('bylocation',$rl) && 
	    ($rad = (int)$cdmod->GetPreference('checkinratelimiting_bylocation')) ) {
	  if( !isset($checkin->lat) )
	    throw new Exception('Missing required source coodinate information');

	  if( $rad > 0 ) {
	    // ratelimiting by radius (in miles)		    
	    // get the location information of this company.
	    $company = cd_company_filter::get_company($checkin->location,'',FALSE);
	    if( !$company->latitude || !$company->longitude )
	      throw new Exception('Location specified has no coordinate information');

	    $lat1 = $company->latitude;
	    $lat2 = $checkin->lat;
	    $lon1 = $company->longitude;
	    $lon2 = $checkin->lng;

	    $theta = $lon1 - $lon2;
	    $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)); 
	    $dist = acos($dist); 
	    $dist = rad2deg($dist); 
	    $miles = $dist * 60 * 1.1515;

	    if( $miles > $rad )
	      throw new Exception('Location specified is too far away from your current location');
	  }
	}

	if( in_array('bytime',$rl) && 
	    ($tl = (int)$this->GetPreference('checkinratelimiting_bytime',10)) > 0 ) {
	  // rate limiting by time limit.
	  // get the last checkin by this user.
	  // and get its created time.
	  $ocheckin = cgsa_checkin::load_by_user($uid,1);
	  if( is_object($ocheckin) ) {
	    $now = time();
	    if( $now - $ocheckin->created < ($tl * 60) ) {
	      $rem = ceil($tl - ($now - $ocheckin->created)/60);
	      throw new Exception('Checkin failed... please try again in '.$rem.' minutes');
	    }
	  }
	}
      }

      if( isset($_FILES) && is_array($_FILES) && count($_FILES) ) {
	$config = cmsms()->GetConfig();
	$destdir = cms_join_path($config['uploads_path'],'_'.$this->GetName());
	@mkdir($destdir);

	$data = array();
	foreach( $_FILES as $key => $value ) {
	  $handler = cge_setup::get_uploader('',$destdir);
	  $filename = cgsa_utils::get_unique_filename($checkin->obid);
	  $res = $handler->handle_upload($key,$filename);
	  $err = $handler->get_error();

	  if( !$res && $err != cg_fileupload::NOFILE )
	    throw new Exception('Upload Error '.$handler->get_errormsg());
	}
	if( empty($res) ) continue;

	$data[] = $res;
      }

      if( count($data) ) {
	$checkin->files = $data;
      }

      $res = $checkin->save();
      $output = $checkin->id;

      // handle any leaderboards that need to be updated.
      $this->UpdateLeaderboards($checkin);

      // send an event
      $this->SendEvent('OnCheckin',array('checkin'=>$checkin));
    }
    catch( Exception $e ) {
      cgsa_utils::return_error($e->getMessage());
    }
    break;

  case 'GET': // GET REQUEST
    try {
      // return a single checkin
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_READ) )
	cgsa_utils::return_error('Insufficient Permissions');
      if( cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
      if( !isset($_REQUEST['cid']) ) cgsa_utils::return_error('Insufficient data');
      $deep = (isset($_REQUEST['deep']))?(int)$_REQUEST['deep']:0;
      
      $output = cgsa_checkin::load_by_id((int)$_REQUEST['cid'],true);
      if( $deep ) {
	// get the owner name.
	$feu = cms_utils::get_module('FrontEndUsers');
	$output['owner_name'] = $feu->GetUserName($output['owner']);
	$cd = cms_utils::get_module('CompanyDirectory');
	if( $cd && $output['location'] ) {
	  $output['location_name'] = $cd->GetCompanyNameFromId($output['location']);
	}
	if( $output['activity'] ) {
	  $act = cgsa_activity::load_by_id($output['activity']);
	  $output['activity_name'] = $act->name;
	}
      }
    }
    catch( Exception $e ) {
      cgsa_utils::return_error($e->getMessage());
    }
    break;

  case 'DEL': // POST request
    // delete a single checkin
    // (cannot have children)
    // owner id must match
    // owner id must match current user.
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_DEL) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['owner']) || !isset($_REQUEST['cid']) )
      cgsa_utils::return_array('insufficient data');
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $uid = $feu->LoggedInId();
    $owner = (int)$_REQUEST['owner'];
    if( $uid != $owner ) cgsa_utils::return_error("Invalid owner got $owner, but found $uid");
    $checkin = cgsa_checkin::load_by_id((int)$_REQUEST['cid']);
    if( !is_object($checkin) ) {
      cgsa_utils::return_error('Specified checkin (id='.$_REQUEST['cid'].') not found');
    }
    if( $checkin->owner != $uid ) {
      cgsa_utils::return_error('Cannot delete this checkin: owner mismatch');
    }
    if( $checkin->parent_id > 0 ) {
      cgsa_utils::return_error('Cannot delete this checkin: there are children');
    }
    $this->SendEvent('PreDeleteCheckin',array('checkin'=>$checkin));
    $res = $checkin->delete();
    $this->SendEvent('PostDeleteCheckin',array('checkin'=>$checkin)); // not sure about this.
    if( !$res )
      {
	cgsa_utils::return_error('Problem deleting this checkin.. internal error');
      }
    break;

  case 'MYCHECKINS': // GET request
    // list a users checkins
    // owner id must match current user
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_READ) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['owner']) ) 
      cgsa_utils::return_error('insufficient data');
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $uid = $feu->LoggedInId();
    $owner = (int)$_REQUEST['owner'];
    if( $uid != $owner ) cgsa_utils::return_error("Invalid owner got $owner, but found $uid");
    $timelimit = (isset($_REQUEST['timelimit']))?(int)$_REQUEST['timelimit']:0;
    $limit = (isset($_REQUEST['limit']))?(int)$_REQUEST['limit']:50;
    $offset = (isset($_REQUEST['offset']))?(int)$_REQUEST['offset']:0;
    $deep = (isset($_REQUEST['deep']))?(int)$_REQUEST['deep']:0;

    $query = new cgsa_checkin_query(array('timelimit'=>$timelimit,'limit'=>$limit,'offset'=>$offset,'owner'=>$owner));
    $rs = $query->execute();
    if( $rs ) {
      if( $deep ) {
	$owner_ids = array();
	$user_list = array();
	$location_ids = array();
	$location_list = array();
	$activity_ids = array();
	$activity_list = array();
	while( !$rs->EOF ) {
	  if( !in_array($rs->fields->owner,$owner_ids) ) $owner_ids[] = $rs->fields->owner;
	  if( !in_array($rs->fields->location,$location_ids) ) $location_ids[] = $rs->fields->location;
	  if( !in_array($rs->fields->activity,$activity_ids) && $rs->fields->activity ) $activity_ids[] = $rs->fields->activity;
	  $rs->MoveNext();
	}
	if( count($owner_ids) ) {
	  $query = new feu_user_query(10000);
	  $query->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$owner_ids);
	  $urs = $query->execute();
	  while( !$urs->EOF ) {
	    $user_list[$urs->fields['id']] = $urs->fields;
	    $urs->MoveNext();
	  }
	}
	if( count($location_ids) ) {
	  $filter = new cd_company_filter(array('idlist'=>$location_ids));
	  $lrs = new cd_company_query($filter);
	  $lrs->set_result_mode(cd_company_query::RESULTS_ARRAY);
	  while( !$lrs->EOF() ) {
	    $location_list[$lrs->fields['id']] = $lrs->fields;
	    $lrs->MoveNext();
	  }
	}
	if( count($activity_ids) ) {
	  $all_activities = cgsa_activity::load_all_as_array();
	  foreach( $all_activities as $one ) {
	    if( in_array($one['id'],$activity_ids) ) {
	      $activity_list[$one['id']] = $one;
	    }
	  }
	}
	$rs->MoveFirst();
      } // end if deep

      $output = array();
      while( !$rs->EOF ) {
	$rec = cgsa_checkin::to_array($rs->fields);
	if( isset($user_list[$rec['owner']]) ) {
	  $rec['owner_name'] = $user_list[$rec['owner']]['username'];
	}
	if( isset($location_list[$rec['location']]) ) {
	  $rec['location_name'] = $location_list[$rec['location']]['company_name'];
	}
	if( isset($activity_list[$rec['activity']]) ) {
	  $rec['activity_name'] = $activity_list[$rec['activity']]['name'];
	}

	$output[] = $rec;
	$rs->MoveNext();
      }
    }
    break;

  case 'APPROVE': // POST request
    // approve a checkin
    // need cid, location, (md5 of the pw), owner
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_APPROVE) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) || !isset($_REQUEST['cid']) || !isset($_REQUEST['lid']) )
      cgsa_utils::return_array('insufficient data');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $uid = $feu->LoggedInId();
    $owner = (int)$_REQUEST['owner'];
    $lid = (int)$_REQUEST['lid'];
    $pw = (isset($_REQUEST['pw']))?$_REQUEST['pw']:'';
    if( $uid != $owner ) cgsa_utils::return_error("Invalid owner got $owner, but expected $uid");
    $checkin = cgsa_checkin::load_by_id((int)$_REQUEST['cid']);
    if( !is_object($checkin) )
      cgsa_utils::return_error('Specified checkin not found');
    if( $checkin->location != $lid )
      cgsa_utils::return_error('Specified checkin does not match location');
    if( !cgsa_utils::check_user_to_location($lid,$uid,$pw) )
      cgsa_utils::return_error('Insufficient permission to approve');
    if( $checkin->approved )
      cgsa_utils::return_error('Specified checkin is already approved');
    $checkin->aporoved = 1;
    $checkin->save();
    $this->SendEvent('OnUpdateCheckin',array('checkin'=>$checkin,'approved'=>1));
    break;
    
  case 'EDIT': // POST request
    // edit a checkin
    // owner id must match current user
    // owner id must match owner of checkin
    // key is one of 'location','activity','msg'
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_EDIT) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_post_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['owner']) || !isset($_REQUEST['cid']) )
      cgsa_utils::return_array('insufficient data');
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $uid = $feu->LoggedInId();
    $owner = (int)$_REQUEST['owner'];
    if( $uid != $owner ) cgsa_utils::return_error("Invalid owner got $owner, but expected $uid");
    $checkin = cgsa_checkin::load_by_id((int)$_REQUEST['cid']);
    if( !is_object($checkin) )
      cgsa_utils::return_error('Specified checkin not found');
    if( $checkin->owner != $uid )
      cgsa_utils::return_error('Cannot edit this checkin: owner mismatch');

    try {
      $modified = FALSE;
      foreach( $_REQUEST as $key => $value ) {
	switch( $key ) {
	case 'activity':
	  $checkin->activity = (int)$value;
	  $modified = TRUE;
	  break;
	case 'location':
	  // validate the location
	  $company = cd_utils::get_company($value);
	  if( !$company )
	    throw new Exception('Location '.$value.' not found');
	  if( $company->status != 'published' )
	    throw new Exception('Location '.$value.' has an invalid status');
	  $checkin->location = (int)$value;
	  $modified = TRUE;
	  break;
	case 'msg':
	  $checkin->msg = substr($value,0,255);
	  $modified = TRUE;
	  break;
	case 'extra1_url':
	  $checkin->extra1_url = trim($_REQUEST['extra1_url']);
	  break;
	case 'del':
	  // delete files...
	  if( isset($checkin->files) && count($checkin->files) ) {
	    if( $value >= 0 && $value < count($checkin->files) ) {
	      $fn = $checkin->files[$value];
	      if( $fn ) {
		$files = glob(cms_join_path($config['uploads_path'],'_'.$this->GetName(),'*'.$fn));
		if( is_array($files) && count($files) ) {
		  foreach($files as $file) {
		    @unlink($file);
		  }
		}
	      }
	      $data = $checkin->files;
	      unset($data[$value]);
	      if( !count($data) ) $data = null;
	      $checkin->data = $data;
	      $modified = TRUE;
	    }
	  }
	  break;

	default:
	  throw new Exception('Cannot set property '.$key.' in location edit operation');
	  break;
	}
      }
      if( $modified ) {
	$checkin->save();
	$this->SendEvent('OnUpdateCheckin',array('checkin'=>$checkin));
      }
    }
    catch(Exception $e) {
      cgsa_utils::return_error('ERROR: '.$e->GetMessage());
    }
    break;

  case 'BYLOCATION': // GET REQUEST
    // get the N latest requests tied to this location.
    // todo: for friends only.
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_READ) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['lid']) ) cgsa_utils::return_error('insufficient data');
    $timelimit = (isset($_REQUEST['timelimit']))?(int)$_REQUEST['timelimit']:0;
    $limit = (isset($_REQUEST['limit']))?(int)$_REQUEST['limit']:50;
    $offset = (isset($_REQUEST['offset']))?(int)$_REQUEST['offset']:0;
    $lid = (isset($_REQUEST['lid']))?(int)$_REQUEST['lid']:0;
    $deep = (isset($_REQUEST['deep']))?(int)$_REQUEST['deep']:0;
    $parms = array('location'=>$lid,'timelimit'=>$timelimit,'limit'=>$limit,'offset'=>$offset);
    if( isset($_REQUEST['unapproved']) ) {
      // are we allowed to handle this parameter?
      if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_APPROVE) )
	cgsa_utils::return_error('Insufficient Permissions');
      if( !isset($_REQUEST['uid']) )
	cgsa_utils::return_error('insufficient data');

      // we will need to see if this user is attached to this company
      $uid = (int)$_REQUEST['uid'];
      if( !cgsa_utils::check_user_to_location($lid,$uid) )
	cgsa_utils::return_error('Insufficient Permissions');

      $parms['approved'] = 0;
    }

    $query = new cgsa_checkin_query($parms);
    $rs = $query->execute();
    if( $rs ) {
      // build list of userids, and location ids, and activity id's
      // we should move this stuff to one place instead of N
      if( $deep ) {
	$owner_ids = array();
	$user_list = array();
	$location_ids = array();
	$location_list = array();
	$activity_ids = array();
	$activity_list = array();
	while( !$rs->EOF ) {
	  if( !in_array($rs->fields->owner,$owner_ids) ) $owner_ids[] = $rs->fields->owner;
	  if( !in_array($rs->fields->location,$location_ids) ) $location_ids[] = $rs->fields->location;
	  if( !in_array($rs->fields->activity,$activity_ids) && $rs->fields->activity ) $activity_ids[] = $rs->fields->activity;
	  $rs->MoveNext();
	}
	if( count($owner_ids) ) {
	  $query = new feu_user_query(10000);
	  $query->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$owner_ids);
	  $urs = $query->execute();
	  while( !$urs->EOF ) {
	    $user_list[$urs->fields['id']] = $urs->fields;
	    $urs->MoveNext();
	  }
	}
	if( count($location_ids) ) {
	  $filter = new cd_company_filter(array('idlist'=>$location_ids));
	  $lrs = new cd_company_query($filter);
	  $lrs->set_result_mode(cd_company_query::RESULTS_ARRAY);
	  while( !$lrs->EOF() ) {
	    $location_list[$lrs->fields['id']] = $lrs->fields;
	    $lrs->MoveNext();
	  }
	}
	if( count($activity_ids) ) {
	  $all_activities = cgsa_activity::load_all_as_array();
	  foreach( $all_activities as $one ) {
	    if( in_array($one['id'],$activity_ids) ) {
	      $activity_list[$one['id']] = $one;
	    }
	  }
	}
	$rs->MoveFirst();
      }

      $output = array();
      while( !$rs->EOF ) {
	$rec = cgsa_checkin::to_array($rs->fields);
	if( isset($user_list[$rec['owner']]) ) {
	  $rec['owner_name'] = $user_list[$rec['owner']]['username'];
	}
	if( isset($location_list[$rec['location']]) ) {
	  $rec['location_name'] = $location_list[$rec['location']]['company_name'];
	}
	if( isset($activity_list[$rec['activity']]) ) {
	  $rec['activity_name'] = $activity_list[$rec['activity']]['name'];
	}
	$output[] = $rec;
	$rs->MoveNext();
      }
    }
    break;

  case 'FRIENDS': // GET REQUEST
    // list of recent friends checkins
    if( !$access_info->check_permission(cgsa_apikey_perms::PERM_CHECKINS_READ) ||
	!$access_info->check_permission(cgsa_apikey_perms::PERM_FRIENDS_READ) )
      cgsa_utils::return_error('Insufficient Permissions');
    if( !cgsa_utils::is_get_request() ) cgsa_utils::return_error('Invalid request method');
    if( !isset($_REQUEST['uid']) )
      cgsa_utils::return_array('insufficient data');
    $uid = trim($_REQUEST['uid']);
    $deep = (isset($_REQUEST['deep']))?(int)$_REQUEST['deep']:0;
    $n = (int)max(1,min(1000,(isset($_REQUEST['n']))?(int)$_REQUEST['n']:50));
    $o = (int)max(0,(isset($_REQUEST['o']))?(int)$_REQUEST['o']:0);
    $feu = cge_utils::get_module('FrontEndUsers');
    if( !$feu ) cgsa_utils::return_error('Internal error');
    $tuid = $feu->LoggedInId();
    if( $uid != $tuid ) cgsa_utils::return_error("Invalid uid. got $uid but expected $tuid");
    // get the friends list
    $friends = cgsa_friends::get_friends($uid);
    if( is_array($friends) && count($friends) > 0 ) {
      // get the checkins by these users.
      $query = new cgsa_checkin_query;
      $query['owners'] = $friends;
      $query['limit'] = $n;
      $query['offset'] = $o;
      $rs = $query->execute();
      if( $rs ) {
	// build list of userids, and location ids, and activity id's
	if( $deep ) {
	  $owner_ids = array();
	  $user_list = array();
	  $location_ids = array();
	  $location_list = array();
	  $activity_ids = array();
	  $activity_list = array();
	  while( !$rs->EOF ) {
	    if( !in_array($rs->fields->owner,$owner_ids) ) $owner_ids[] = $rs->fields->owner;
	    if( !in_array($rs->fields->location,$location_ids) ) $location_ids[] = $rs->fields->location;
	    if( !in_array($rs->fields->activity,$activity_ids) && $rs->fields->activity ) $activity_ids[] = $rs->fields->activity;
	    $rs->MoveNext();
	  }
	  if( count($owner_ids) ) {
	    $query = new feu_user_query(10000);
	    $query->add_and_opt(feu_user_query_opt::MATCH_USERLIST,$owner_ids);
	    $urs = $query->execute();
	    while( !$urs->EOF ) {
	      $user_list[$urs->fields['id']] = $urs->fields;
	      $urs->MoveNext();
	    }
	  }
	  if( count($location_ids) ) {
	    $filter = new cd_company_filter(array('idlist'=>$location_ids));
	    $lrs = new cd_company_query($filter);
	    $lrs->set_result_mode(cd_company_query::RESULTS_ARRAY);
	    while( !$lrs->EOF() ) {
	      $location_list[$lrs->fields['id']] = $lrs->fields;
	      $lrs->MoveNext();
	    }
	  }
	  if( count($activity_ids) ) {
	    $all_activities = cgsa_activity::load_all_as_array();
	    foreach( $all_activities as $one ) {
	      if( in_array($one['id'],$activity_ids) ) {
		$activity_list[$one['id']] = $one;
	      }
	    }
	  }
	}

	$rs->MoveFirst();
	$output = array();
	while( !$rs->EOF ) {
	  $rec = cgsa_checkin::to_array($rs->fields);
	  if( isset($user_list[$rec['owner']]) ) {
	    $rec['owner_name'] = $user_list[$rec['owner']]['username'];
	  }
	  if( isset($location_list[$rec['location']]) ) {
	    $rec['location_name'] = $location_list[$rec['location']]['company_name'];
	  }
	  if( isset($activity_list[$rec['activity']]) ) {
	    $rec['activity_name'] = $activity_list[$rec['activity']]['name'];
	  }
	  
	  $output[] = $rec;
	  $rs->MoveNext();
	}
      }
    }
    break;

  default:
    // unknown op
    cgsa_utils::return_error('Unknown command');
  }

cgsa_utils::return_success($output);

#
# EOF
#
?>