<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(CGSocialApp::PERMISSION) ) exit;

// 
// initialize
//
$object = new cgsa_apikey();
$this->SetCurrentTab('keys');
$error = null;

//
// setup
//
if( isset($params['aid']) )
  {
    $oid = (int)$params['aid'];
    $object = cgsa_apikey::load_by_id($oid);
  }

// 
// process form data
//
if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }

try
{
  if( isset($params['appname']) )
    {
      $object['appname'] = trim($params['appname']);
    }
  if( isset($params['email']) )
    {
      $object['email'] = trim($params['email']);
    }
  if( isset($params['apikey']) )
    {
      $object['apikey'] = trim($params['apikey']);
    }
  if( isset($params['active']) )
    {
      $object['active'] = (int)trim($params['active']);
    }
  if( isset($params['expires_Month']) )
    {
      $object['expires'] = mktime(23,59,59,(int)$params['expires_Month'],(int)$params['expires_Day'],(int)$params['expires_Year']);
    }
  if( isset($params['apikey']) )
    {
      $object['apikey'] = trim($params['apikey']);
    }
  if( isset($params['submit']) && $params['submit'] == $this->Lang('prompt_generate'))
    {
      $object['apikey'] = $object->generate_api_key();
    }
}
catch( Exception $e )
{
  echo $this->ShowErrors($e->getMessage());
  $error = 1;
}

if( !$error && isset($params['submit']) && $params['submit'] == $this->Lang('submit') )
  {
    try
      {
	$perms = cgsa_apikey_perms::get_all_perms();
	foreach( $perms as $name )
	  {
	    $object->remove_permission($name);
	    if( isset($params[$name]) && $params[$name] == 1 )
	      {
		$object->set_permission($name);
	      }
	  }

	$object->save();
	$this->SetMessage($this->Lang('item_edited'));
	$this->RedirectToTab($id);
      }
    catch( Exception $e )
      {
	echo $this->ShowErrors($e->getMessage());
      }
  }

//
// give everything to smarty
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_edit_apikey',$returnid,$params));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('apikey',$object);
$smarty->assign('allperms',cgsa_apikey_perms::get_all_perms());
if( $error ) $smarty->assign('error',$error);

//
// display
//
echo $this->ProcessTemplate('admin_edit_apikey.tpl');

#
# EOF
#
?>