<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: FrontEndUsers (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

//
// initialization
//
$activity = new cgsa_activity;
$this->SetCurrentTab('activities');

//
// setup
//
if( isset($params['actid']) ) {
  $activity = cgsa_activity::load_by_id((int)$params['actid']);
  if( !$activity ) {
    $this->SetError($this->Lang('error_activitynotfound'));
    $this->RedirectToTab($id);
  }
}

//
// handle form data
//
if( isset($params['cancel']) ) {
  $this->RedirectToTab($id);
 }
if( isset($params['submit']) ) {
  if( isset($params['name']) ) {
    $activity->name = trim($params['name']);
  }
  if( isset($params['description']) ) {
    $activity->description = trim($params['description']);
  }
  if( isset($params['parent_id']) ) {
    $activity->parent_id = (int)$params['parent_id'];
  }

  try {
    if( isset($params['delete_image']) ) {
      $activity->delete_files();
    }
    $res = $activity->save(); // this will give us an id if not already set.
    
    $destdir = cms_join_path($config['uploads_path'],'_'.$this->GetName(),'activities',$activity->id);
    $handler = cge_setup::get_uploader($id,$destdir);

    if( $handler->check_upload('image','',FALSE) ) {
      cge_dir::mkdirr($destdir);
      $res = $handler->handle_upload('image');
      $err = $handler->get_error();

      if( !$res && $err != cg_fileupload::NOFILE ) {
	// upload die.
	$this->SetError($this->Lang('error_upload'));
	$this->RedirectToTab($id);
      }
      if( $res ) {
	$activity->delete_files();

	// file uploaded, save again.
	$activity->image = basename($res);
	$activity->save();
      }
    }

    $this->SetMessage($this->Lang('msg_success'));
    $this->RedirectToTab($id);
  }
  catch(Exception $e) {
    echo $this->ShowErrors($e->getMessage());
  }
}

// 
// give everything to smarty
//
$dropdown = '';
{
  $data = cgsa_activity::load_all_as_array();
  if( is_array($data) ) {
    $dropdown = array(-1=>$this->Lang('none'));
    for( $i = 0; $i < count($data); $i++ ) {
      $depth = count(explode('.',$data[$i]['hierarchy']));
      $dropdown[$data[$i]['id']] = str_repeat('&nbsp;',$depth).$data[$i]['name'];
    }
  }
}

$smarty->assign('formstart',$this->CGCreateFormSTart($id,'admin_addactivity',$returnid,$params,false,'post',
						     'multipart/form-data'));
$smarty->assign('formend',$this->CreateFormEnd());
if( is_array($dropdown) && count($dropdown) ) {
  $smarty->assign('activities',$dropdown);
 }
$smarty->assign('activity',$activity);

echo $this->ProcessTemplate('admin_addactivity.tpl');
#
# EOF
#
?>