<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSocialApp (c) 2012 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

class CGSocialApp extends CGExtensions
{
  const PERMISSION = 'Manage Social API Keys';

  function __construct()
  {
    require_once(dirname(__FILE__).'/defines.php');
    parent::__construct();

    $smarty = cmsms()->GetSmarty();
    $smarty->register_function('cgsa_selactivity',array('cgsa_utils','smarty_selactivity'));

    $this->AddImageDir('images');
  }

  function GetName() { return get_class($this); }
  function _GetModuleAlias() { return strtolower($this->GetName());  }
  function GetFriendlyName() { return $this->GetPreference('friendlyname',$this->Lang('friendlyname')); }
  function GetVersion() { return '1.1.10'; }
  function GetHelp() { return @file_get_contents(dirname(__FILE__).'/help.html.inc');  }
  function GetAuthor() { return 'Robert Campbell (calguy1000)'; }
  function GetAuthorEmail() { return 'calguy1000@cmsmadesimple.org'; }
  function IsPluginModule() { return TRUE; }
  function HasAdmin() { return TRUE; }
  function GetAdminSection() { return 'content'; }
  function GetAdminDescription() { return $this->Lang('moddescription'); }
  function MinimumCMSVersion() { return '1.11.2'; }
  function InstallPostMessage() { return $this->Lang('postinstall'); }
  function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  function UninstallPreMessage() { return $this->Lang('preuninstall'); }
  function HandlesEvents() { return TRUE; }
  function LazyLoadAdmin() { return TRUE; }

  function GetChangeLog()
  {
    $fn = dirname(__FILE__).'/changelog.inc';
    return file_get_contents($fn);
  }

  function GetHeaderHTML()
  {
	$obj = cge_utils::get_module('JQueryTools');
    if( is_object($obj) )
      {
$tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
        return $this->ProcessTemplateFromData($tmpl);
      }
  }	

  function InitializeFrontend()
  {
    $this->RestrictUnknownParams();
    $pageid = cmsms()->GetContentOperations()->GetDefaultContent();

    // route for RESTFUL api
    $this->RegisterRoute('/app\/v1\/users$/',
			 array('action'=>'users','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/activities$/',
			 array('action'=>'activities','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/checkins$/',
			 array('action'=>'checkins','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/friends$/',
			 array('action'=>'friends','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/locations$/',
			 array('action'=>'locations','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/leaderboards$/',
			 array('action'=>'leaderboards','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/badges$/',
			 array('action'=>'badges','showtemplate'=>'false','returnid'=>$pageid));
    $this->RegisterRoute('/app\/v1\/social$/',
			 array('action'=>'social','showtemplate'=>'false','returnid'=>$pageid));

    // routes for various views
    $this->RegisterRoute('/activity\/(?P<returnid>[0-9]+)\/(?P<activity>[0-9]+)\/(?P<junk>.*?)$/',
			 array('action'=>'view_activity'));

    // parameters for frontend list checkins.
    $this->SetParameterType('location',CLEAN_INT);
    $this->SetParameterType('activity',CLEAN_INT);
    $this->SetParameterType('timelimit',CLEAN_INT);
    $this->SetParameterType('owner',CLEAN_INT);
    $this->SetParameterType('limit',CLEAN_INT);
    $this->SetParameterType('offset',CLEAN_INT);
    $this->SetParameterType('sortby',CLEAN_STRING);
    $this->SetParameterType('sortorder',CLEAN_STRING);
    $this->SetParameterType('template',CLEAN_STRING); 

    // parameters for list activities
    $this->SetParameterType('list_template',CLEAN_STRING);
    $this->SetParameterType('start',CLEAN_STRING);
    $this->SetParameterType('junk',CLEAN_STRING);
  }

  function InitializeAdmin()
  {
    $this->CreateParameter('action','',$this->Lang('param_action'));
    $this->CreateParameter('location','',$this->Lang('param_locationid'));
    $this->CreateParameter('activity','',$this->Lang('param_activity'));
    $this->CreateParameter('timelimit','',$this->Lang('param_timelimit'));
    $this->CreateParameter('owner','',$this->Lang('param_owner'));
    $this->CreateParameter('limit','',$this->Lang('param_limit'));
    $this->CreateParameter('offset','',$this->Lang('param_offset'));
    $this->CreateParameter('sortby','created',$this->Lang('param_sortby'));
    $this->CreateParameter('sortorder','DESC',$this->Lang('param_sortorder'));
    $this->CreateParameter('template','',$this->Lang('param_template'));
    $this->CreateParameter('list_template','',$this->Lang('param_list_template'));
    $this->CreateParameter('start','',$this->Lang('param_start'));
  }

  function VisibleToAdminUser()
  {
    return $this->CheckPermission(self::PERMISSION) ||
      $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission('Modify Templates');
  }

  function GetDependencies()
  {
    return array('FrontEndUsers'=>'1.21.1','CompanyDirectory'=>'1.16.3',
		 'CGExtensions'=>'1.31.2','CGFavs'=>'1.0.2',
		 'CGSimpleSmarty'=>'1.5','CGJobMgr'=>'1.2.7');
  }

  public function GetEventDescription($eventname)
  {
    return $this->Lang('describe_event_'.$eventname);
  }

  public function GetEventHelp($eventname)
  {
    return $this->Lang('help_event_'.$eventname);
  }

  public function get_pretty_url($id,$action,$returnid = '',$params = array(),$inline = false)
  {
    switch( $action ) {
    case 'view_activity':
      if( isset($params['activity']) ) {
	$activity = (int)$params['activity'];
	$obj = cgsa_activity::load_by_id($activity);
	if( is_object($obj) ) {
	  return sprintf("activity/%d/%d/%s",$returnid,$activity,munge_string_to_url($obj->name));
	}
      }
      break;
    }
  }

  /**
   * This method is used to update the applicable leaderboards givena checkin.
   * This is a protected member in this class, because putting it in another class would require it to be public.
   *
   * @internal
   * @access private
   * @ignore
   */
  protected function UpdateLeaderboards(cgsa_checkin $checkin)
  {
    // 1.  given the checkin ... find any and all matching leaderboards
    // for each match 
    //  increment the score for this user on that leaderboard
    //  then 
  }

  /**
   * Setup CGJobMgr Jobs
   *
   * @internal
   * @access private
   * @ignore
   */
  protected function SetupJobs()
  {
    $job = new cgjobmgr_job($this->GetName().' update leaderboards');
    $job->set_recur_interval($this->GetPreference('interval_updateleaderboards',15));
    $task = new cgjobmgr_iterativetask('process one leaderboard');
    $task->set_function(array('cgsa_leaderboard_tasks','update_one_leaderboard'));
    $job->add_task($task);
    $job->save();
    $this->SetPreference('job: update leaderboards',$job->id);

    $job = new cgjobmgr_job($this->GetName().' update badges');
    $job->set_recur_interval($this->GetPreference('interval_updatebadges',30));
    $task = new cgjobmgr_iterativetask('process badges for leaderboard');
    $task->set_function(array('cgsa_leaderboard_tasks','update_badges_for_leaderboard'));
    $job->add_task($task);
    $job->save();
  }
}

?>
