<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Postcode (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow conversion of postal codes
#  from the geoname service.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

#
# Initialization
#
$this->SetCurrentTab('import');
$fieldmap = '';
$delimeter = '';
$filename = '';
$policy = 0;

#
# Setup
#
if( !isset($_FILES[$id.'file']) || $_FILES[$id.'file']['size'] == 0 )
  {
    $this->SetError($this->Lang('error_nofile'));
    $this->RedirectToTab($id);
  }
else if( $_FILES[$id.'file']['error'] != 0 )
  {
    $this->SetError($this->Lang('error_fileupload'));
    $this->RedirectToTab($id);
  }
$filename = $_FILES[$id.'file']['name'];

if( isset($params['delimeter']) )
  {
    $delimeter = trim($params['delimeter']);
    if( $delimeter == '[TAB]' ) $delimeter = "\t";
  }
if( $delimeter == '' )
  {
    $this->SetError($this->Lang('error_empty_delimeter'));
    $this->RedirectToTab($id);
  }
if( isset($params['fieldmap']) )
  {
    $fieldmap = trim($params['fieldmap']);
  }
if( $fieldmap == '' )
  {
    $this->SetError($this->Lang('error_empty_fieldmap'));
    $this->RedirectToTab($id);
  }
if( isset($params['import_policy']) )
  {
    $policy = (int)$params['import_policy'];
  }

// split the fieldmap into a map.
$map = array();
$tmp = explode("\n",$fieldmap);
foreach($tmp as $one)
{
  list($key,$value) = explode('=',$one,2);
  $map[strtolower($key)] = $value;
}

// falidate the fieldmap
if( !isset($map['country']) || !isset($map['postal']) || !isset($map['placename']) 
    || !isset($map['latitude']) || !isset($map['longitude']) )
  {
    $this->SetError($this->Lang('error_invalidmap'));
    $this->RedirectToTab($id);
  }

$this->SetPreference('import_delimeter',$delemeter);
$this->SetPreference('import_fieldmap',$fieldmap);

// good so far, so now try to read the temporary file.
$lines = file($_FILES[$id.'file']['tmp_name']);
if( !is_array($lines) || count($lines) == 0 )
  {
    $this->SetError($this->Lang('error_readfile'));
    $this->RedirectToTab($id);
  }

// now process the lines
$errors = array();
$added = 0;
$squery = 'SELECT place FROM '.cms_db_prefix().'module_postcode WHERE country = ? AND postal = ? LIMIT 1';
$uquery = 'UPDATE '.cms_db_prefix().'module_postcode SET place = ?, state = ?, latitude = ?, longitude = ? 
            WHERE country = ? AND postal = ?';
$iquery = 'INSERT INTO '.cms_db_prefix().'module_postcode (country,postal,place,state,latitude,longitude)
           VALUES (?,?,?,?,?,?)';
for( $i = 0; $i < count($lines); $i++ )
  {
    $line = $lines[$i];

    // strip off comments
    $p = strrpos($line, '//');
    if ($p) {
      $line = trim(substr($line, 0, $p));
    }
    
    $p = strrpos($line, '#');
    if( $p ) {
      $line = trim(substr($line, 0, $p));
    }
    
    // strip off extra whitespace
    $line = trim($line);
    
    // skip empty lines
    if ($line == '') {
      continue;
    }
     
    $fields = explode($delimeter,$line);
    if( count($fields) < count($map) )
      {
	$errors[] = $this->Lang('error_numfields',$i+1);
	continue;
      }
    $data = array();
    foreach( $map as $name => $index )
      {
	$data[$name] = $fields[$index-1];
      }

    // find out if this record exists
    $tmp = $db->GetOne($squery,array($data['country'],$data['postal']));
    $dbr = '';
    if( $tmp )
      {
	// it's a duplicate
	switch($policy)
	  {
	  case 0: // error
	    $errors[] = $this->Lang('error_duplicatepostal',$i+1);
	    continue;
	    break;

	  case 1: // ignore
	    continue;
	    break;

	  case 2: // overwrite
	    $dbr = $db->Execute($uquery,array($data['placename'],$data['state'],
					      $data['latitude'],$data['longitude'],$data['country'],$data['postal']));
	    if( !$dbr )
	      {
		$tmp = $this->Lang('error_insertfailed',$i+1);
		$tmp .= ' - '.$db->ErrorMsg();
		$errors[] = $tmp;
		continue;
	      }
	  }
      }
    else {
      // insert
      $dbr = $db->Execute($iquery,array($data['country'],$data['postal'],$data['placename'],$data['state'],
					$data['latitude'],$data['longitude']));
      if( !$dbr )
	{
	  $tmp = $this->Lang('error_insertfailed',$i+1);
	  $tmp .= ' - '.$db->ErrorMsg();
	  $errors[] = $tmp;
	  continue;
	}
    }

    $added++;
  }
      
    
if( count($errors) )
  {
    $str = '<ul>';
    foreach($errors as $one) $str .= '<li>'.$one.'</li>';
    $str .= '</ul>'."\n";
    $this->SetError($str);
    die($str);
  }

$this->SetMessage($this->Lang('msg_import_numimported',$added));
$this->RedirectToTab($id);

#
# EOF
#
?>