<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Postcode (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow conversion of postal codes
#  from the geoname service.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

class Postcode extends CGExtensions
{
  function GetName()
  {
    return 'Postcode';
  }

  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }
	
  function GetVersion()
  {
    return '1.2.1';
  }

  function GetHelp()
  {
    return file_get_contents(dirname(__FILE__).'/help.inc');
  }

  public function LazyLoadAdmin() { return TRUE; }
  public function LazyLoadFrontend() { return TRUE; }

  function GetAuthor()
  {
    return 'calguy1000';
  }

  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }

  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }
  
  function IsPluginModule()
  {
    return true;
  }

  function HasAdmin()
  {
    return true;
  }

  function GetAdminSection()
  {
    return 'extensions';
  }

  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }

  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Site Preferences');
  }

  function GetDependencies()
  {
    return array('CGExtensions'=>'1.31');
  }

  function MinimumCMSVersion()
  {
    return "1.11.2";
  }
	
  function SetParameters()
  {
    $this->RestrictUnknownParams();
    $this->SetParameterType('choice',CLEAN_STRING);
    $this->SetParameterType('next',CLEAN_STRING);
    $this->SetParameterType('prev',CLEAN_STRING);
  }

  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }

  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }

  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	

  protected function _db_lookup_zip($country,$postal)
  {
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.cms_db_prefix().'module_postcode
                     WHERE country = ? AND postal = ?';
    $row = $db->GetRow($query,array($country,$postal));
    
    if( !$row ) return FALSE;
    return $row;
  }

  protected function _online_lookup_zip($country,$postal)
  {
    $post_url = 'http://api.geonames.org/postalCodeSearchJSON';
    $username = $this->GetPreference('geonames_username');
    if( !$username ) return FALSE;
    $post_string = "username={$username}&country={$country}&postalcode_startsWith={$postal}&maxRows=1";
    $request = curl_init($post_url); // initiate curl object
    curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response
    curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)
    curl_setopt($request, CURLOPT_POSTFIELDS, $post_string); // use HTTP POST to send form data
    curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment this line if you get no gateway response.
    $post_response = curl_exec($request); // execute curl post and store results in $post_response
    curl_close ($request); // close curl object

    $json = json_decode($post_response,true);
    if( !is_array($json) || !is_array($json['postalCodes']) || !count($json['postalCodes']) ) {
      $msg = 'Unknown error occurred';
      if( is_array($json) && isset($json['status']) && isset($json['status']['message']) ) {
	$msg = 'ERROR: '.$json['status']['message'];
      }
      audit('',$this->GetName(),$msg);
      return FALSE;
    }
    $data = array('country'=>$json['postalCodes'][0]['countryCode'],
		  'postal'=>$json['postalCodes'][0]['postalCode'],
		  'state'=>$json['postalCodes'][0]['adminCode1'],
		  'place'=>$json['postalCodes'][0]['placeName'],
		  'latitude'=>$json['postalCodes'][0]['lat'],
		  'longitude'=>$json['postalCodes'][0]['lng'],
		  );
    return $data;
  }

  protected function _store_zip($data)
  {
    $db = cmsms()->GetDb();

    $query = 'INSERT INTO '.cms_db_prefix().'module_postcode (country,postal,place,state,latitude,longitude)
               VALUES (?,?,?,?,?,?)';
    $dbr = $db->Execute($query,
			array($data['country'],$data['postal'],$data['place'],$data['state'],$data['latitude'],$data['longitude']));
    if( !$dbr ) 
      {
	echo "DEBUG: $query<br/>";
	echo "DEBUG: ".$db->sql.'<br/>'.$db->ErrorMsg().'<br/>'; die();
	return FALSE;
      }
    return TRUE;
  }  

  public function Lookup_Zip($country,$postal,$echars = '')
  {
    if( empty($country) || empty($postal) ) {
      return FALSE;
    }

    if( $echars == '' || !is_numeric($echars) ) {
      $echars = (int)$this->GetPreference('effective_chars');
    }
    if( $echars > 0 ) {
      $postal = substr($postal,0,$echars);
    }

    $opmode = $this->GetPreference('operation_mode',0);
    $data = '';
    switch( $opmode ) {
    case 1: // dbonly
      $data = $this->_db_lookup_zip($country,$postal);
      break;

    case 2: // dbfirst
      $data = $this->_db_lookup_zip($country,$postal);
      if( $data === FALSE ) {
	$data = $this->_online_lookup_zip($country,$postal);
      }
      break;

    case 3: // dbfirst_cache
      $data = $this->_db_lookup_zip($country,$postal);
      if( $data === FALSE ) {
	$data = $this->_online_lookup_zip($country,$postal);
	if( $data !== FALSE ) {
	  $this->_store_zip($data);
	}
      }
      break;

    case 4: // onlineonly
      $data = $this->_online_lookup_zip($country,$postal);
      break;
    }

    return $data;
  }

} // class

?>
