<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Glossary (c) Samuel Goldstein
# This file: (c) (calguy1000@cmsmadesimple.org)
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class glossary_smarty
{
  private function __construct() {}

  public static function glossary_terms($params,$content,&$smarty,$repeat)
  {
    if( !$content ) return;

    $mod = cms_utils::get_module('Glossary');
    $db = cmsms()->GetDb();
    $targ        = $mod->GetPreference('glossary_page', '');
    $inline      = ($mod->GetPreference('glossary_inline', '0') == '1');
    $show_single = ($mod->GetPreference('show_single', '0') == '1');
    $query       = "SELECT term_id, term, tip, definition FROM " . cms_db_prefix() . "module_glossary_term";
    $dbresult    = $db->Execute($query);

    while( $dbresult && !$dbresult->EOF ) {
      $row = $dbresult->fields;
      $link = $mod->CreateTermLink('\2', $row['term'], $row['term_id'], $row['tip'], $row['definition'], $inline, $targ, $show_single);
      $term = preg_replace('/([\/#@$!.?*{}()|\[\]])/', '\\\1', $row['term']);

      $txt = $mod->Lang('friendlyname');
      if( $row['tip'] ) {
	$txt = $row['tip'];
      }
      $txt = '<abbr class="glossary_term" title="'.$txt.'" id="glossary_'.$row['term_id'].'">\2</abbr>';

      $content = preg_replace('/(\s+)(' . $term . ')(\W)/i', '\1'.$txt.'\3', $content);
      $dbresult->MoveNext();
    }

    return $content;
  }
} // end of class

?>