<h3>What Does This Do?</h3>
<p>This allows the administrator to create a list of terms, which will appear on a page. Clicking on the term will expand it to include the definition.</p>
<h3>How Do I Use It</h3>
<h4>Standard Glossary Page</h4>
<p>Install it by placing the module in a page or template using the smarty tag &#123;cms_module module='Glossary'}</p>
<p>You can have it start with a term expanded by passing a term=Term parameter, or passing a tid=term_id.</p>
<p>You can limit it to a specific category by passing a cat="Category" parameter.</p>
<p>You can override the default template by passing a template="template_id" parameter (use the numeric
id for the template, or the template name).</p>
<p>You can limit it to definitions containing a keyword by passing a keyword="keyword".</p>
<p>This module also will read the URL, and support specifications of "term" or "cat" on the URL. So, for example, you could have an URL like http://mysite/index.php?page=10&amp;term=myterm. If page 10 includes the Glossary module, it will expand the definition of "myterm".
<h4>Expanding Lists</h4>
<p>Sometimes, you will want a short list of terms, but have clicks on those terms to load a full list. For example, you might want three random terms in the sidebar, but clicking on those terms should show the selected term in a complete term list. To do this, set the "no_pass_restriction" variable.</p>
<p>For example, on your sidebar you want three random terms from category "foo". Clicking on a term should show a full, alphabetical list of category "foo" with the specific term open. Your tag for the sidebar will then look like:</p>
<p>&#123;cms_module module='Glossary' cat='foo' sort='random' term_count='3' no_pass_restriction='sort,term_count'}</p>
<h4>WYSIWYG/Smarty</h4>
<p>In the admin, you can enable the WYSIWYG editor for terms and term definitions. Because of the way the system uses terms, it is not recommended
to use markup in the terms themselves. If you insist on doing it (and some people do, in fact, have good reasons to do so), be aware that the glossary page nav may be messed up.</p>
<p>You can also enable smarty processing on term definitions. This will permit you to do all sorts of wild stuff like self-linking and other smarty madness. Hey -- if you know enough to go on the black diamond run, you know the risks! I will say no more.</p>
<h3>Linked Terms</h3>
<h4>Overview</h4>
<p>You can make terms that show up in your pages link to their definitions, either "inline" (where it replaces the content of your page), or by linking to your main Glossary page. This is the "inline" option which you can set in the "Glossary Links Options" section of the Glossary Admin Prefs.</p>
<p>You can also choose to have links go to a page with only the definition of your term, and you can control the display of this by altering the template. This also set in "Glossary Links Options" section of the Glossary Admin Prefs.</p> 
<h4>Single Term</h4>
<p>You can tag specific words to be linked to the Glossary if you want, by placing the following tag in a page: &#123;cms_module module='Glossary' action='def' term='foo'}, where you replace "foo" with a term that you have in your glossary.
<h3>Smarty tags:</h3>
<ul>
  <li><code>{glossary_terms}</code> smarty block plugin.
  <h4>Description:</h4>
  <p>This plugin will replace all instances of the terms detected between the {glossary_terms} smarty tag and the {/glossary_terms} smarty tag with an &lt;abbr&gt; html tag.  The abbr tag will have a uniquely generated id, and a class that will allow processing the abbreviation with javascript.</p>
  <h4>Usage:</h4>
  <p>This plugin is best used within the page template, surrounding the {content} tag.  i.e:</p>
  <pre><code>{glossary_terms}{content}{/glossary_terms}</code></pre>
  </li>
</ul>
<h3>Ajaxy Term Lookup</h3>
  <p>if using the <code>{glossary_terms}</code> plugin to automatically convert matching terms in the html content into <abbr> tags, it is quite simple using the CGSimpleSmarty module and some jquery code to display popup windows containing the definition of a term when hovering over the term.  Please look at one posible solution:</p>
  <pre><code>{JQueryTools action=require lib=ui nocache}
&lt;script type="text/javascript"&gt;
//&lt;![CDATA[
$(document).ready(function(){
  $('abbr.glossary_term').tooltip({
    content: function() {
      var el = $(this);
      var tid = el.attr('id').substr(9);
      var out = '';
      $.ajax({
        url: '{module_action_link module=Glossary action=showsingle urlonly=1 jsfriendly=1}&showtemplate=false',
        data: 'cntnt01tid='+tid,
        async: false,
        success: function(data) {
	  out = data;
        }
      });
      return out;
    }
  });
});
//]]&gt;
&lt;/script&gt;</code></pre>
<h3>Credits</h3>
<p>Development of this module has been generously sponsored by Matt Hornsby.</p>
<p>Extensive testing, QA, ideas, and non-negotiable demands provided by Paul "InSiPiD" Noone and Daniel "Westis" Westergren.</p>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report, please visit the
module homepage at <a href="http://dev.cmsmadesimple.org/projects/glossary/">the CMS Developer Forge</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, SjG, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>
</ul>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2006, Samuel Goldstein <a href="mailto:sjg@cmsmodules.com">&lt;sjg@cmsmodules.com&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>