<?php
#-------------------------------------------------------------------------
# Module: Glossary / Dictionary / FAQ module
# Version: 0.6.6, SjG
# http://dev.cmsmadesimple.org/projects/glossary
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (ted@cmsmadesimple.org)
# http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


#-------------------------------------------------------------------------
final class Glossary extends CMSModule
{
  function GetName() { return 'Glossary'; }
  function GetFriendlyName() { return $this->Lang('friendlyname'); }	
  function MinimumCMSVersion() { return '1.11.3'; }
  function GetVersion() { return '1.0'; }
  function GetHelp() { return @file_get_contents(dirname(__FILE__).'/help.inc'); }
  function GetAuthor() { return 'SjG'; }
  function GetAuthorEmail() { return 'sjg@cmsmodules.com'; }
  function GetChangeLog() { return file_get_contents(dirname(__FILE__).'/changelog.inc'); }	
  function IsPluginModule() { return true; }	
  function HasAdmin() { return true; }
  function GetAdminSection() { return 'content'; }
  function GetAdminDescription() { return $this->Lang('moddescription'); }	
  function VisibleToAdminUser() { return $this->CheckPermission('Modify Glossary'); }
  function GetDependencies() { return array(); }
  function InstallPostMessage()	{ return $this->Lang('postinstall'); }
  function UninstallPostMessage() { return $this->Lang('postuninstall'); }
  function LazyLoadAdmin() { return TRUE; }

  function SearchResult($returnid, $articleid, $attr = '')
  {
    $targ = $this->GetPreference('glossary_page', '');
    if (!empty($targ)) $returnid = $targ;

    $result = array();
    if ($attr == 'glossary') {
      $db  = cmsms()->GetDb();
      $q   = 'SELECT * FROM ' . cms_db_prefix() . 'module_glossary_term
              WHERE term_id = ?';
      $row = $db->GetRow($q, array($articleid) );
      if ($row) {
	$result[0] = utf8_encode(html_entity_decode($this->GetFriendlyName()));
	$result[1] = $row['term'];
	$prettyurl = "glossary/{$row['term']}/{$returnid}";
	$result[2] = $this->CreateLink('cntnt01', 'showsingle', $returnid, $row['term'], 
				       array('tid' => $row['term_id']),
				       '', true, true, '', true, $prettyurl);
      }
    }
    return $result;
  }

  function SearchReindex(&$module)
  {
    $db     = cmsms()->GetDb();
    $query  = 'SELECT * FROM ' . cms_db_prefix() . 'module_glossary_term';
    $result = $db->Execute($query);

    while ($result && !$result->EOF) {
      $row = $result->fields;
      $module->AddWords($this->GetName(), $row['term_id'], 'glossary', $row['term'] . ' ' . $row['definition']);
      $result->MoveNext();
    }
    $result->Close();
  }

  public function CreateTermLink($term, $safeTermSrc, $termid, $tip, $def, $inline = true, $targ = '', 
				 $show_single = false, $cat = '', $cid = -1)
  {
    $config = cmsms()->GetConfig();
    if ($cid == -1 && isset(cmsms()->variables['content_id'])) {
      $cid = cmsms()->variables['content_id'];
    }
    $safeTerm = preg_replace('/[^a-zA-Z]/', "", $safeTermSrc);
    if ($this->GetPreference('process_smarty', '') == 'yes') {
      $def = $this->ProcessTemplateFromData($def);
    }
    if (empty($tip)) {
      $tip = strip_tags(preg_replace('/\"|\n|\r/', '', $def));
      if (strlen($tip) > 35) {
	$tip = substr($tip, 0, 35);
	$tip = substr($tip, 0, strrpos($tip, ' ')) . '...';
      }
    }
    if ($inline) {
      if ($config['internal_pretty_urls']) {
	$lnk = '<a class="glossary" href="' . $config['root_url'] . '/glossary';
	$lnk .= ($show_single ? 'sing' : '');
	$lnk .= '/' . $termid;
	$lnk .= (($cat != '') ? '/' . $cat : '');
	$lnk .= '/' . $cid;
	$lnk .= '" title="' . $tip . '">' . $term . '</a>';
      } else {
	$lnk = '<a class="glossary" href="' . $config['root_url'] . '/index.php?mact=Glossary,cntnt01,';
	$lnk .= ($show_single ? 'showsingle' : 'show');

	$lnk .= ',1&amp;cntnt01tid=' . $termid;
	if ($cid != -1) {
	  $lnk .= '&amp;cntnt01returnid=' . $cid;
	}
	$lnk .= (($cat != '' && $cat != -1) ? '&amp;cat=' . $cat : '');
	$lnk .= '&amp;page=' . $cid;
	$lnk .= ($show_single ? '' : '#' . $safeTerm);
	$lnk .= '" title="' . htmlspecialchars($tip) . '">' . $term . '</a>';
      }
      return $lnk;
    } else {
      $lnk = '<a class="glossary" href="' . $config['root_url'];
      $lnk .= '/index.php?page=' . $targ . '&amp;tid=' . $termid;
      $lnk .= (($cat != '') ? '&amp;cat=' . $cat : '');
      $lnk .= '#' . $safeTerm . '" title="' . htmlspecialchars($tip) . '">' . $term . '</a>';
      return $lnk;
    }
  }

  public function DoAction($action, $id, $params, $returnid = -1)
  {
    switch ($action) {
    case 'def':
    case 'show':
      $action = 'default';
      parent::DoAction($action, $id, $params, $returnid);
      break;

    case 'random':
      $action = 'default';
      $params['sort'] = 'random';
      parent::DoAction($action, $id, $params, $returnid);
      break;

    case 'defaultadmin':
    case 'listterms':
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->ListTerms($id, $params, $returnid);
      }
      break;

    case 'editterm':
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->EditTerm($id, $params, $returnid);
      }
      break;

    case 'saveterm':
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->SaveTerm($id, $params, $returnid);
      }
      break;

    case 'delterm':
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->DeleteTerm($id, $params, $returnid);
      }
      break;

    case "listtempl":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->_listTemplates($id, $params, $returnid);
      }
      break;

    case "edittempl":
      if ($this->checkPerm())
	$this->initAdminNav($id, $params, $returnid);
      $this->editTemplate($id, $params, $returnid);
      break;

    case "deletetempl":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->delTemplate($id, $params, $returnid);
      }
      break;

    case "submittempl":
      if ($this->checkPerm())
	$this->initAdminNav($id, $params, $returnid);
      $this->submitTemplate($id, $params, $returnid);
      break;

    case "listcats":
      if ($this->checkPerm())
	$this->initAdminNav($id, $params, $returnid);
      $this->listCats($id, $params, $returnid);
      break;

    case "editcat":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->editCat($id, $params, $returnid);
      }
      break;

    case "deletecat":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->delCat($id, $params, $returnid);
      }
      break;

    case "submitcat":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->submitCat($id, $params, $returnid);
      }
      break;

    case "adminprefs":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->EditPrefs($id, $params, $returnid);
      }
      break;

    case "submitprefs":
      if ($this->checkPerm()) {
	$this->initAdminNav($id, $params, $returnid);
	$this->SubmitPrefs($id, $params, $returnid);
      }
      break;

    default:
      parent::DoAction($action, $id, $params, $returnid);
      break;
    }		
  }
	
  protected function checkPerm($perm = 'Modify Glossary')
  {
    if (!$this->CheckPermission($perm)) {
      $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
      return false;
    }
    return true;
  }

  protected function DisplayErrorPage($id, &$params, $returnid, $message = '')
  {
    $this->smarty->assign('title_error', $this->Lang('error'));
    if ($message != '') {
      $this->smarty->assign_by_ref('message', $message);
    }

    // Display the populated template
    echo $this->ProcessTemplate('error.tpl');
  }
	
  protected function ListTerms($id, &$params, $returnid, $message = '')
  {
    $db = cmsms()->GetDb();

    if (isset($params['submit_massdelete']) && isset($params['sel']) && is_array($params['sel']) && count($params['sel']) > 0) {
      foreach ($params['sel'] as $term_id)
	$this->doDeleteTerm($term_id);
    }

    $entryarray = array();
    $total      = 0;
    $step       = $this->GetPreference('number_show_admin', '20');
    $startPoint = ((isset($params['start']) && !empty($params['start'])) ? $params['start'] : 0);
    $filter     = ((isset($params['filter']) && !empty($params['filter'])) ? $params['filter'] : 0);
    $cats       = array();
    if ($filter > 0) {
      $query    = "SELECT count(t.term_id) as total FROM " . cms_db_prefix() . "module_glossary_term t, " . cms_db_prefix() . "module_glossary_cat c, " . cms_db_prefix() . "module_glossary_term_cat ct " . " where ct.category_id = c.category_id and ct.term_id=t.term_id and c.category_id=?";
      $dbresult = $db->Execute($query, array($filter));
    } else {
      $query    = "SELECT count(term_id) as total FROM " . cms_db_prefix() . "module_glossary_term";
      $dbresult = $db->Execute($query);
    }
    $show_termids = $this->GetPreference('show_termids', 0);

    if ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $total = $row['total'];
    } else {
      $total = 0;
    }

    $query = "SELECT t.term_id, t.term, t.definition, GROUP_CONCAT(c.name SEPARATOR ', ') as category FROM " . cms_db_prefix() . "module_glossary_term t LEFT JOIN " . cms_db_prefix() . "module_glossary_term_cat ct ON ct.term_id = t.term_id LEFT JOIN " . cms_db_prefix() . "module_glossary_cat c ON ct.category_id = c.category_id";
    $sql_vars = array();

    if ($filter > 0) {
      $query .= " WHERE c.category_id=?";
      $sql_vars[] = $filter;
    }

    $query .= ' GROUP BY t.term_id ORDER by t.term';
    $dbresult = $db->SelectLimit($query, $step, $startPoint, $sql_vars);

    $rowclass = 'row1';

    $param_add = array();
    if ($filter > 0) {
      $param_add['filter'] = $filter;
    }

    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $onerow = new stdClass();

      $onerow->id       = $row['term_id'];
      $onerow->namelink = $this->CreateLink($id, 'editterm', $returnid, '', 
					    array('wid' => $row['term_id'],
						  'start' => $startPoint,
						  'filter' => $filter
						  ), '', true);

      $onerow->name       = $row['term'];
      $onerow->safename   = preg_replace('[^a-zA-Z]', "", $row['term']);
      $onerow->rowclass   = $rowclass;
      $onerow->definition = strip_tags($row['definition']);
      $onerow->category   = $row['category'];

      $theme = CmsAdminThemeBase::GetThemeObject();
      $onerow->editlink = $this->CreateLink($id, 'editterm', $returnid, 
					    $theme->DisplayImage('icons/system/edit.gif', $this->Lang('edit'), '', '', 'systemicon'), 
					    array_merge($param_add, array('wid' => $row['term_id'],'start' => $startPoint)));
      $onerow->dellink  = $this->CreateLink($id, 'delterm', $returnid, 
					    $theme->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), 
					    array_merge($param_add, array('wid' => $row['term_id'],'start' => $startPoint)), 
					    $this->Lang('suredelete', $row['term']));
      $onerow->select   = $this->CreateInputCheckbox($id, 'sel[]', $row['term_id']);
      array_push($entryarray, $onerow);
      ($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
    }


    $cats[$this->Lang('title_all')] = '';
    $dbresult = $db->Execute("select category_id, name from " . cms_db_prefix() . "module_glossary_cat");

    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $cats[$row['name']] = $row['category_id'];
    }

    if ($startPoint >= $step) {
      $prev_id = $startPoint - $step;
      $this->smarty->assign('prev_page', 
			    $this->CreateLink($id, 'listterms', $returnid, $this->Lang('prev'), 
					      array_merge($param_add, array('start' => $prev_id))));
    }
    if ($startPoint + $step < $total) {
      $next_id = $startPoint + $step;
      $this->smarty->assign('next_page', 
			    $this->CreateLink($id, 'listterms', $returnid, $this->Lang('next'), 
					      array_merge($param_add, array('start' => $next_id))));
    }
    if (ceil($total / $step) > 1) {
      $curpg   = floor($startPoint / $step) + 1;
      $linkstr = '';
      $first   = 1;
      for ($i = 0; $i < $total; $i += $step) {
	$thisPg = floor($i / $step) + 1;
	if ($first) {
	  $first = 0;
	} else {
	  $linkstr .= ' : ';
	}
	if ($i == $startPoint) {
	  $linkstr .= '[' . $thisPg . ']';
	} else {
	  $linkstr .= $this->CreateLink($id, 'listterms', $returnid, $thisPg, 
					array_merge($param_add, array('start' => $i)));
	}
      }
      $this->smarty->assign('page_no', 'Page ' . $curpg . ' of ' . ceil($total / $step));
      $this->smarty->assign_by_ref('page_links', $linkstr);
    }
    $this->smarty->assign('column_termid', $this->Lang('column_termid'));
    $this->smarty->assign('column_term', $this->Lang('column_term'));
    $this->smarty->assign('column_definition', $this->Lang('column_definition'));
    $this->smarty->assign('column_category', $this->Lang('column_category'));
    $this->smarty->assign('column_action', $this->Lang('column_action'));
    $this->smarty->assign('column_select', $this->Lang('column_select'));

    $this->smarty->assign('title_filter_category', $this->Lang('title_filter_category'));

    $this->smarty->assign('startform', $this->CreateFormStart($id, 'listterms', $returnid));
    $this->smarty->assign('endform', $this->CreateFormEnd());
    $this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang("filter")));
    $this->smarty->assign('submit_massdelete', $this->CreateInputSubmit($id, 'submit_massdelete', $this->Lang('delete_selected'), 
									'', '', $this->Lang('areyousure_deletemultiple')));

    $this->smarty->assign('input_filter_category', $this->CreateInputDropdown($id, 'filter', $cats, -1, 
									      isset($params['filter']) ? $params['filter'] : '', 
									      "onChange=\"submit()\""));

    $this->smarty->assign_by_ref('items', $entryarray);
    $this->smarty->assign('itemcount', count($entryarray));

    if ($message != "") {
      $this->smarty->assign_by_ref('message', $message);
    }

    $theme = CmsAdminThemeBase::GetThemeObject();
    $this->smarty->assign('addlink', 
			  $this->CreateLink($id, 'editterm', $returnid, 
					    $theme->DisplayImage('icons/system/newobject.gif', $this->Lang('addterm'), '', '', 'systemicon'), 
					    array_merge($param_add, array('start' => $startPoint)), 
					    '', false, false, '') . ' ' . 
			  $this->CreateLink($id, 'editterm', $returnid, $this->Lang('addterm'), 
					    array_merge($param_add, array('start' => $startPoint)), '', false, false, 'class="pageoptions"'));

    $this->smarty->assign('title_section', $this->Lang('title_term_list'));
    if ($show_termids) {
      $this->smarty->assign('show_termids', '1');
    } else {
      $this->smarty->assign('show_termids', '0');
    }
    // Display the populated template
    echo $this->ProcessTemplate('listterms.tpl');
  }

  protected function SaveTerm($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
    if (isset($params['wid'])) {
      // updating
      $query    = 'UPDATE ' . cms_db_prefix() . 'module_glossary_term set term=?,tip=?,definition=? WHERE term_id=?';
      $dbresult = $db->Execute($query, array($params['term'],$params['tip'],$params['definition'],$params['wid']));
      if ($dbresult === false) {
	return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());
      }
      $term_id = $params['wid'];
    } else {
      // new record
      $term_id = $db->GenID(cms_db_prefix() . 'module_glossary_term_seq');
      $query   = 'INSERT INTO ' . cms_db_prefix() . 'module_glossary_term (term_id, term, tip, definition, create_date) VALUES (?,?,?,?,?)';		
      $dbresult = $db->Execute($query, 
			       array($term_id,$params['term'],$params['tip'],$params['definition'],trim($db->DBTimeStamp(time()), "'")));
      if ($dbresult === false) {
	return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());
      }
    }
    if (isset($params['cats'])) {
      if (!is_array($params['cats'])) {
	$params['cats'] = array($params['cats']);
      }
      $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_term_cat where term_id=?';
      $dbresult = $db->Execute($query, array($term_id));
      if ($dbresult === false) {
	return $this->displayError($db->ErrorMsg());
      }
      foreach ($params['cats'] as $thisCat) {
	$query    = 'INSERT INTO ' . cms_db_prefix() . 'module_glossary_term_cat (term_id, category_id) VALUES (?,?)';
	$dbresult = $db->Execute($query, array($term_id,$thisCat));
	if ($dbresult === false) {
	  return $this->displayError($db->ErrorMsg());
	}
      }
    }
		
    // update Search
    $module = cmsms()->GetModuleInstance('Search');
    if ($module != FALSE) {
      $txt = $params['term'] . ' ' . $params['definition'];
      $module->AddWords($this->GetName(), $term_id, 'glossary', $txt, NULL);
    }
    return $this->ListTerms($id, $params, $returnid, $this->Lang('termadded'));
  }
	
  protected function DoDeleteTerm($term_id)
  {
    $db       = cmsms()->GetDb();
    // updating
    $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_term WHERE term_id=?';
    $dbresult = $db->Execute($query, array($term_id));
    if ($dbresult === false)
      return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());

    $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_term_cat WHERE term_id=?';
    $dbresult = $db->Execute($query, array($term_id));
    if ($dbresult === false)
      return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());

    // update Search
    $module = cmsms()->GetModuleInstance('Search');
    if ($module != FALSE)
      $module->DeleteWords($this->GetName(), $term_id, 'glossary');
  }
	
  protected function DeleteTerm($id, &$params, $returnid)
  {
    if (isset($params['wid']))
      $this->DoDeleteTerm($params['wid']);

    return $this->ListTerms($id, $params, $returnid, $this->Lang('termdeleted'));
  }
	
  protected function EditTerm($id, &$params, $returnid, $message = "")
  {
    $db = cmsms()->GetDb();
		
    $cats       = array();
    $membercats = array();
    $query      = "SELECT category_id, name FROM " . cms_db_prefix() . "module_glossary_cat";
    $dbresult   = $db->Execute($query);
    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $cats[$row['name']] = $row['category_id'];
    }

    if (isset($params['wid'])) {
      $query    = "SELECT * FROM " . cms_db_prefix() . "module_glossary_term WHERE term_id=?";
      $dbresult = $db->Execute($query, array($params['wid']));
      if ($dbresult !== false && $row = $dbresult->FetchRow()) {
	$term = $row['term'];
	$def  = $row['definition'];
	$tip  = $row['tip'];
      }
      $query    = "SELECT category_id FROM " . cms_db_prefix() . "module_glossary_term_cat WHERE term_id=?";
      $dbresult = $db->Execute($query, array($params['wid']));
      while ($dbresult !== false && $row = $dbresult->FetchRow()) {
	array_push($membercats, $row['category_id']);
      }

    } else {
      $term = '';
      $def  = '';
      $tip  = '';
    }

    $this->smarty->assign('startform', $this->CreateFormStart($id, 'saveterm', $returnid));
    $this->smarty->assign('endform', $this->CreateFormEnd());
    $this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 'Submit'));

    $this->smarty->assign('title_field_term', $this->Lang('title_term'));
    $this->smarty->assign('title_field_tip', $this->Lang('title_tip'));
    $this->smarty->assign('title_field_definition', $this->Lang('title_definition'));
    $this->smarty->assign('title_field_cats', $this->Lang('title_cats'));
		
    $this->smarty->assign('input_field_term', $this->CreateTextArea(($this->GetPreference('wysiwyg_terms', 'no') == 'yes'), $id, $term, 'term', 'pageheadtags', '', '', '', 80, 5));
    $this->smarty->assign('input_field_tip', $this->CreateInputText($id, 'tip', $tip, 40, 255));
    $this->smarty->assign('input_field_definition', $this->CreateTextArea(($this->GetPreference('wysiwyg_definitions', 'no') == 'yes'), $id, $def, 'definition'));
    $this->smarty->assign('input_field_cats', $this->CreateInputSelectList($id, 'cats[]', $cats, $membercats, 5));

    if (isset($params['wid'])) {
      $this->smarty->assign('hidden', $this->CreateInputHidden($id, 'wid', $params['wid']) . $this->CreateInputHidden($id, 'start', $params['start']) . $this->CreateInputHidden($id, 'filter', $params['filter']));
    } else {
      $this->smarty->assign('hidden', $this->CreateInputHidden($id, 'start', $params['start']) . $this->CreateInputHidden($id, 'filter', isset($params['filter'])?$params['filter']:''));
    }
    if ($message != '') {
      $this->smarty->assign('message', $message);
    }
    echo $this->ProcessTemplate('editterm.tpl');
  }

  protected function _listTemplates($id, &$params, $returnid, $message = "")
  {
    $theme = CmsAdminThemeBase::GetThemeObject();
    $db = cmsms()->GetDb();

    //Load the shows
    $entryarray = array();
    $query    = "SELECT template_id, name FROM " . cms_db_prefix() . "module_glossary_template ORDER by name";
    $dbresult = $db->Execute($query);
    $rowclass = 'row1';

    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $onerow = new stdClass();
      $onerow->id       = $row['template_id'];
      $onerow->name     = $this->CreateLink($id, 'edittempl', $returnid, $row['name'], 
					    array('template_id' => $row['template_id']));
      $onerow->rowclass = $rowclass;
			
      $onerow->editlink   = $this->CreateLink($id, 'edittempl', $returnid, 
					      $theme->DisplayImage('icons/system/edit.gif', $this->Lang('edit'), '', '', 'systemicon'), 
					      array('template_id' => $row['template_id']));
      $onerow->deletelink = $this->CreateLink($id, 'deletetempl', $returnid, 
					      $theme->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), 
					      array('template_id' => $row['template_id']), $this->Lang('areyousure', 'Template'));
      array_push($entryarray, $onerow);
      ($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
    }

    $this->smarty->assign_by_ref('items', $entryarray);
    $this->smarty->assign('itemcount', count($entryarray));
    $this->smarty->assign('section', $this->Lang('templatelist'));
    $this->smarty->assign('column_template', $this->Lang('column_template'));
    $this->smarty->assign('notemplates', $this->Lang('notemplates'));
    if ($message != '') {
      $this->smarty->assign_by_ref('message', $message);
    }

    $this->smarty->assign('addlink', $this->CreateLink($id, 'edittempl', $returnid, $theme->DisplayImage('icons/system/newobject.gif', $this->Lang('addtemplate'), '', '', 'systemicon'), array(), '', false, false, '') . ' ' . $this->CreateLink($id, 'edittempl', $returnid, $this->Lang('addtemplate'), array(), '', false, false, 'class="pageoptions"'));

    // Display template
    echo $this->ProcessTemplate('listtemplates.tpl');
  }
	
  protected function editTemplate($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();

    $types   = array();
    $typeids = array();
    if (isset($params['template_id'])) {
      // editing a template
      $query      = 'SELECT name, template FROM ' . cms_db_prefix() . 'module_glossary_template WHERE template_id=?';
      $dbresult   = $db->Execute($query, array($params['template_id']));
      $row        = $dbresult->FetchRow();
      $templateid = $params['template_id'];
      $name       = $row['name'];
      $template   = $row['template'];
    } else {
      // adding a template
      $templateid = '';
      $name       = '';
      $template   = '';
      $this->smarty->assign('op', 'Add Template');
    }
    $this->smarty->assign('startform', $this->CreateFormStart($id, 'submittempl', $returnid));
    $this->smarty->assign('endform', $this->CreateFormEnd());
    $this->smarty->assign('hidden', $this->CreateInputHidden($id, 'template_id', $templateid));
    $this->smarty->assign('title_name', $this->Lang('title_name'));
    $this->smarty->assign('title_template', $this->Lang('title_template'));

    $this->smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 20, 255));
    $this->smarty->assign('input_template', $this->CreateTextArea(false, $id, $template, 'templ'));

    $this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 'Submit'));
    echo $this->ProcessTemplate('edittemplate.tpl');
  }

  protected function submitTemplate($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
    if (!empty($params['template_id'])) {
      // updating a template
      $query       = 'UPDATE ' . cms_db_prefix() . 'module_glossary_template set name=?, template=? WHERE template_id=?';
      $dbresult    = $db->Execute($query, array($params['name'],$params['templ'],$params['template_id']));
      $template_id = $params['template_id'];
    } else {
      // creating a template
      $query       = 'INSERT INTO ' . cms_db_prefix() . 'module_glossary_template (template_id, name, template) VALUES (?,?,?)';
      $template_id = $db->GenID(cms_db_prefix() . 'module_glossary_template_seq');
      $dbresult    = $db->Execute($query, array($template_id,$params['name'],$params['templ']));
    }
    $this->SetTemplate('glossary_' . $template_id, $params['templ']);
    $this->_listTemplates($id, $params, $returnid, $this->Lang('templateupdated'));
  }
	
  protected function delTemplate($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
    if (!empty($params['template_id'])) {
      // updating a template
      $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_template WHERE template_id=?';
      $dbresult = $db->Execute($query, array($params['template_id']));
      $this->DeleteTemplate('glossary_' . $params['template_id']);
    }
    $this->_listTemplates($id, $params, $returnid, $this->Lang('templatedeleted'));
  }

  protected function listCats($id, &$params, $returnid, $message = "")
  {
    $theme = CmsAdminThemeBase::GetThemeObject();
    $db = cmsms()->GetDb();

    //Load the shows
    $entryarray = array();

    $query    = "SELECT category_id, name FROM " . cms_db_prefix() . "module_glossary_cat ORDER by name";
    $dbresult = $db->Execute($query);
    $rowclass = 'row1';
    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $onerow = new stdClass();
      $onerow->id       = $row['category_id'];
      $onerow->name     = $this->CreateLink($id, 'editcat', $returnid, $row['name'], 
					    array('category_id' => $row['category_id']));
      $onerow->rowclass = $rowclass;

      $onerow->editlink   = $this->CreateLink($id, 'editcat', $returnid, 
					      $theme->DisplayImage('icons/system/edit.gif', $this->Lang('edit'), '', '', 'systemicon'), 
					      array('category_id' => $row['category_id']));
      $onerow->deletelink = $this->CreateLink($id, 'deletecat', $returnid, 
					      $theme->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'), 
					      array('category_id' => $row['category_id']), $this->Lang('areyousure', 'Category'));
      array_push($entryarray, $onerow);
      ($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
    }

    $this->smarty->assign_by_ref('items', $entryarray);
    $this->smarty->assign('itemcount', count($entryarray));
    $this->smarty->assign('section', $this->Lang('listcats'));
    $this->smarty->assign('column_category', $this->Lang('column_category'));
    $this->smarty->assign('nocats', $this->Lang('nocats'));
    if ($message != '') {
      $this->smarty->assign_by_ref('message', $message);
    }
    $this->smarty->assign('addlink', $this->CreateLink($id, 'editcat', $returnid, $theme->DisplayImage('icons/system/newobject.gif', $this->Lang('addcat'), '', '', 'systemicon'), array(), '', false, false, '') . ' ' . $this->CreateLink($id, 'editcat', $returnid, $this->Lang('addcat'), array(), '', false, false, 'class="pageoptions"'));
    // Display template
    echo $this->ProcessTemplate('listcats.tpl');
  }

  protected function editCat($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
		
    $types   = array();
    $typeids = array();
    if (isset($params['category_id'])) {
      $query    = 'SELECT name FROM ' . cms_db_prefix() . 'module_glossary_cat WHERE category_id=?';
      $dbresult = $db->Execute($query, array($params['category_id']));
      $row      = $dbresult->FetchRow();
      $catid    = $params['category_id'];
      $name     = $row['name'];
    } else {
      $catid = '';
      $name  = '';
    }
    $this->smarty->assign('startform', $this->CreateFormStart($id, 'submitcat', $returnid));
    $this->smarty->assign('endform', $this->CreateFormEnd());
    $this->smarty->assign('hidden', $this->CreateInputHidden($id, 'category_id', $catid));
    $this->smarty->assign('title_name', $this->Lang('title_name'));
    $this->smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 20, 255));
    $this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 'Submit'));
    echo $this->ProcessTemplate('editcat.tpl');
  }

  protected function submitCat($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
    if (!empty($params['category_id'])) {
      $query    = 'UPDATE ' . cms_db_prefix() . 'module_glossary_cat set name=? WHERE category_id=?';
      $dbresult = $db->Execute($query, array($params['name'],$params['category_id']));
    } else {
      $query       = 'INSERT INTO ' . cms_db_prefix() . 'module_glossary_cat (category_id, name) VALUES (?,?)';
      $category_id = $db->GenID(cms_db_prefix() . 'module_glossary_cat_seq');
      $dbresult    = $db->Execute($query, array($category_id,$params['name']));
    }
    $this->listCats($id, $params, $returnid, $this->Lang('catupdated'));
  }

  protected function delCat($id, &$params, $returnid)
  {
    $db = cmsms()->GetDb();
    if (!empty($params['category_id'])) {
      // updating a template
      $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_cat WHERE category_id=?';
      $dbresult = $db->Execute($query, array($params['category_id']));
      if ($dbresult === false) {
	return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());
      }
      $query    = 'DELETE FROM ' . cms_db_prefix() . 'module_glossary_term_cat WHERE category_id=?';
      $dbresult = $db->Execute($query, array($params['category_id']));
      if ($dbresult === false) {
	return $this->DisplayErrorPage($id, $params, $returnid, $db->ErrorMsg());
      }
    }
    $this->listCats($id, $params, $returnid, $this->Lang('catdeleted'));
  }
	
  protected function initAdminNav($id, &$params, $returnid)
  {
    $theme = CmsAdminThemeBase::GetThemeObject();
    $this->smarty->assign('innernav', $this->CreateLink($id, 'listterms', $returnid, $theme->DisplayImage('icons/topfiles/adminlog.gif', $this->Lang('listterms'), '', '', 'systemicon'), array()) . $this->CreateLink($id, 'listterms', $returnid, $this->Lang('listterms'), array()) . ' : ' . $this->CreateLink($id, 'listcats', $returnid, $theme->DisplayImage('icons/topfiles/preferences.gif', $this->Lang('listcats'), '', '', 'systemicon'), array()) . $this->CreateLink($id, 'listcats', $returnid, $this->Lang('listcats'), array()) . ' : ' . $this->CreateLink($id, 'listtempl', $returnid, $theme->DisplayImage('icons/topfiles/template.gif', $this->Lang('listtempl'), '', '', 'systemicon'), array()) . $this->CreateLink($id, 'listtempl', $returnid, $this->Lang('listtempl'), array()) . ' : ' . $this->CreateLink($id, 'adminprefs', $returnid, $theme->DisplayImage('icons/topfiles/siteprefs.gif', $this->Lang('manageprefs'), '', '', 'systemicon'), array()) . $this->CreateLink($id, 'adminprefs', $returnid, $this->Lang('manageprefs'), array()));
  }

  protected function EditPrefs($id, &$params, $returnid, $message = '')
  {
    $db = cmsms()->GetDb();
    $templates = array();
    $query     = "SELECT template_id, name FROM " . cms_db_prefix() . "module_glossary_template ORDER by name";
    $dbresult  = $db->Execute($query);
    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $templates[$row['name']] = $row['template_id'];
    }

    $this->smarty->assign('tab_headers', $this->StartTabHeaders() . $this->SetTabHeader('display', $this->Lang('title_display_tab')) . $this->SetTabHeader('link', $this->Lang('title_link_tab')) . $this->SetTabHeader('admin', $this->Lang('title_admin_tab')) . $this->EndTabHeaders() . $this->StartTabContent());
    $this->smarty->assign('end_tab', $this->EndTab());
    $this->smarty->assign('tab_footers', $this->EndTabContent());
    $this->smarty->assign('start_display_tab', $this->StartTab('display'));
    $this->smarty->assign('start_admin_tab', $this->StartTab('admin'));
    $this->smarty->assign('start_link_tab', $this->StartTab('link'));

    $this->smarty->assign('startform', $this->CreateFormStart($id, 'submitprefs', $returnid));
    $this->smarty->assign('endform', $this->CreateFormEnd());
    $this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 'Submit'));

    $this->smarty->assign('title_default_template', $this->Lang('title_default_template'));
    $this->smarty->assign('title_default_single_term_template', $this->Lang('title_default_single_term_template'));
    $this->smarty->assign('title_number_show', $this->Lang('title_number_show'));
    $this->smarty->assign('title_default_number_show', $this->Lang('title_default_number_show'));
    $this->smarty->assign('title_disable_prettyurls', $this->Lang('title_disable_prettyurls'));
    $this->smarty->assign('title_glossary_inline', $this->Lang('title_glossary_inline'));
    $this->smarty->assign('glossary_prettyurls_help', $this->Lang('glossary_prettyurls_help'));
    $this->smarty->assign('glossary_inline_help', $this->Lang('glossary_inline_help'));
    $this->smarty->assign('title_single_term', $this->Lang('title_single_term'));
    $this->smarty->assign('title_glossary_page', $this->Lang('title_glossary_page'));
    $this->smarty->assign('glossary_page_help', $this->Lang('glossary_page_help'));
    $this->smarty->assign('title_show_termids', $this->Lang('title_show_termids'));
    $this->smarty->assign('title_number_spining_chars', $this->Lang('title_number_spining_chars'));
    $this->smarty->assign('title_process_smarty', $this->Lang('title_process_smarty'));
    $this->smarty->assign('title_wysiwyg_definitions', $this->Lang('title_wysiwyg_definitions'));
    $this->smarty->assign('title_wysiwyg_terms', $this->Lang('title_wysiwyg_terms'));

    $this->smarty->assign('input_default_template', $this->CreateInputDropdown($id, 'default_template', $templates, -1, $this->GetPreference('default_template')));
    $this->smarty->assign('input_default_single_term_template', $this->CreateInputDropdown($id, 'default_single_term_template', $templates, -1, $this->GetPreference('default_single_term_template')));

    $characters = array(
			'1' => '1',
			'2' => '2',
			'3' => '3',
			'4' => '4',
			'5' => '5',
			'6' => '6',
			'7' => '7',
			'8' => '8',
			'9' => '9',
			'10' => '10'
			);
    $this->smarty->assign('input_number_spining_chars', $this->CreateInputDropdown($id, 'spining_chars', $characters, -1, $this->GetPreference('spining_chars', '5')));

    $sizes = array(
		   '5' => '5',
		   '10' => '10',
		   '15' => '15',
		   '20' => '20',
		   '25' => '25',
		   '30' => '30',
		   '40' => '40',
		   '50' => '50',
		   '75' => '75',
		   '100' => '100',
		   '200' => '200',
		   '1000' => '1000'
		   );
    $this->smarty->assign('input_number_show', $this->CreateInputDropdown($id, 'number_show', $sizes, -1, $this->GetPreference('number_show', '20')));
    $this->smarty->assign('input_number_show_admin', $this->CreateInputDropdown($id, 'number_show_admin', $sizes, -1, $this->GetPreference('number_show_admin', '20')));

    $this->smarty->assign('input_single_term', $this->CreateInputCheckbox($id, 'show_single', 1, $this->GetPreference('show_single', 0)) . '&nbsp;' . $this->Lang('title_single_term_label'));

    $this->smarty->assign('input_disable_prettyurls', $this->CreateInputCheckbox($id, 'disable_prettyurls', 1, $this->GetPreference('disable_prettyurls', '0')) . '&nbsp;' . $this->Lang('title_disable_prettyurls_label'));
    $this->smarty->assign('input_glossary_inline', $this->CreateInputCheckbox($id, 'glossary_inline', 1, $this->GetPreference('glossary_inline', '1')) . '&nbsp;' . $this->Lang('title_glossary_inline_label'));
    $reqs = array($this->Lang('no') => 'no',$this->Lang('yes') => 'yes');
    $this->smarty->assign('input_process_smarty', $this->CreateInputRadioGroup($id, 'process_smarty', $reqs, $this->GetPreference('process_smarty', 'no')));
    $this->smarty->assign('input_wysiwyg_definitions', $this->CreateInputRadioGroup($id, 'wysiwyg_definitions', $reqs, $this->GetPreference('wysiwyg_definitions', 'no')));
    $this->smarty->assign('input_wysiwyg_terms', $this->CreateInputRadioGroup($id, 'wysiwyg_terms', $reqs, $this->GetPreference('wysiwyg_terms', 'no')));
    $this->smarty->assign('title_wysiwyg_terms_help', $this->Lang('title_wysiwyg_terms_help'));

    $this->smarty->assign('input_show_termids', $this->CreateInputCheckbox($id, 'show_termids', 1, $this->GetPreference('show_termids', 0)) . '&nbsp;' . $this->Lang('title_show_termids'));

    $contentops = cmsms()->GetContentOperations();
    //$ret[]= array(lang('parent').':',$contentops->CreateHierarchyDropdown($this->mId, $this->mParentId));
    $this->smarty->assign('input_glossary_page', $contentops->CreateHierarchyDropdown('', $this->GetPreference('glossary_page', ''), $id . 'glossary_page'));

    $this->smarty->assign_by_ref('message', $message);
    $this->smarty->assign('section', $this->Lang('manageprefs'));
		
    // Display template
    echo $this->ProcessTemplate('adminprefs.tpl');
  }
	
  protected function SubmitPrefs($id, &$params, $returnid)
  {
    $this->SetPreference('default_template', isset($params['default_template']) ? $params['default_template'] : '');
    $this->SetPreference('default_single_term_template', isset($params['default_single_term_template']) ? $params['default_single_term_template'] : '');
    $this->SetPreference('number_show', isset($params['number_show']) ? $params['number_show'] : '20');
    $this->SetPreference('number_show_admin', isset($params['number_show_admin']) ? $params['number_show_admin'] : '20');
    $this->SetPreference('show_single', isset($params['show_single']) ? $params['show_single'] : 0);
    $this->SetPreference('disable_prettyurls', isset($params['disable_prettyurls']) ? $params['disable_prettyurls'] : '0');
    $this->SetPreference('glossary_inline', isset($params['glossary_inline']) ? $params['glossary_inline'] : '0');
    $this->SetPreference('show_termids', isset($params['show_termids']) ? $params['show_termids'] : 0);
    $this->SetPreference('spining_chars', isset($params['spining_chars']) ? $params['spining_chars'] : '5');
    $this->SetPreference('glossary_page', (isset($params['glossary_page']) && $params['glossary_page'] != -1) ? $params['glossary_page'] : '');
    $this->SetPreference('process_smarty', isset($params['process_smarty']) ? $params['process_smarty'] : 'no');
    $this->SetPreference('wysiwyg_definitions', isset($params['wysiwyg_definitions']) ? $params['wysiwyg_definitions'] : 'no');
    $this->SetPreference('wysiwyg_terms', isset($params['wysiwyg_terms']) ? $params['wysiwyg_terms'] : 'no');

    return $this->EditPrefs($id, $params, $returnid, $this->Lang('prefsupdated'));
  }
	
	
  /* pass an associative array with one or more of the following set:
   tid = term id
   term = term name
   catid = category id
   cat = category name
   term_count = number to show (if list query)
   keyword = keyword to find in definition
   sort = random/alpha
   show_nav = true/false
  */
  protected function SmartyTermList($opts = array(), $id, $returnid)
  {
    $db     = cmsms()->GetDb();
    $config = cmsms()->GetConfig();
    $enc    = $config['default_encoding'];
    if ($enc == '') $enc = 'utf-8';

    $query   = 'SELECT t.term_id, t.term, t.tip, t.definition';
    $from    = array(cms_db_prefix() . 'module_glossary_term t');
    $where   = array();
    $prms    = array();
    $no_pass = array();
    if (!isset($opts['cat']) && isset($_REQUEST['cat'])) {
      $opts['cat'] = $_REQUEST['cat'];
    }
    if (!isset($opts['catid']) && isset($_REQUEST['catid'])) {
      $opts['catid'] = $_REQUEST['catid'];
    }
    if (!isset($opts['term']) && isset($_REQUEST['term'])) {
      $opts['term'] = $_REQUEST['term'];
    }
    if (!isset($opts['tid']) && isset($_REQUEST['tid'])) {
      $opts['tid'] = $_REQUEST['tid'];
    }
    if (isset($opts['no_pass_restriction'])) {
      $np = explode(',', $opts['no_pass_restriction']);
      foreach ($np as $tnp) {
	$no_pass[$tnp] = 1;
      }
    }
    if (isset($opts['cat'])) {
      array_push($from, cms_db_prefix() . 'module_glossary_cat c');
      array_push($from, cms_db_prefix() . 'module_glossary_term_cat tc');
      array_push($where, 'c.name = ? and c.category_id = tc.category_id and t.term_id = tc.term_id');
      array_push($prms, $opts['cat']);
    } elseif (isset($opts['catid'])) {
      array_push($from, cms_db_prefix() . 'module_glossary_term_cat tc');
      array_push($where, 'tc.category_id=? and t.term_id = tc.term_id');
      array_push($prms, $opts['catid']);
    }
    if (isset($opts['term'])) {
      array_push($where, 't.term=?');
      array_push($prms, $opts['term']);
    }
    if (isset($opts['termid'])) {
      array_push($where, 't.term_id=?');
      array_push($prms, $opts['termid']);
    }

    if (isset($opts['keyword'])) {
      array_push($where, "t.definition like '%" . addslashes($opts['keyword']) . "%'");
    }

    $query .= ' from ' . implode(',', $from);
    if (count($where) > 0) {
      $query .= ' where ' . implode(' and ', $where);
    }

    $sort = '';
    if(isset($opts['sort'])) {
      $sort = $opts['sort'];
    }

    switch($sort) {
    default:
    case 'alpha':
      $query .= ' order by term asc';
      break;
    case 'create_date':
      $query .= ' order by create_date desc';
      break;
    case 'random':
      $query .= ' order by rand()';
      break;
    }

    if (!isset($opts['start'])) {
      $opts['start'] = 0;
    }

    $maxSize = $this->GetPreference('number_show', '20');
    if (isset($opts['term_count']) && !empty($opts['term_count'])) {
      $maxSize = $opts['term_count'];
    }

    $dbresult     = $db->Execute($query, $prms);
    $count        = 0;
    $selectedTerm = -1;
    $entryarray   = array();
    while ($dbresult !== false && $row = $dbresult->FetchRow()) {
      $onerow     = array();
      $linkparams = array();
      if (!isset($no_pass['term_count'])) {
	$linkparams['term_count'] = $maxSize;
      }
      if (isset($opts['sort']) && !isset($no_pass['sort'])) {
	$linkparams['sort'] = $opts['sort'];
      }
      if (isset($opts['start']) && !isset($no_pass['start'])) {
	$linkparams['start'] = $opts['start'];
      }
      if (isset($opts['keyword']) && !isset($no_pass['keyword'])) {
	$linkparams['keyword'] = $opts['keyword'];
      }
      if (isset($opts['cat']) && !isset($no_pass['cat'])) {
	$linkparams['cat'] = $opts['cat'];
      }
      if (isset($opts['template']) && !isset($no_pass['template'])) {
	$linkparams['template'] = $opts['template'];
      }
      $onerow['id']       = $row['term_id'];
      $onerow['name']     = $row['term'];
      $onerow['tip']      = $row['tip'];
      $onerow['safeterm'] = preg_replace('/[^a-zA-Z]/', "", $row['term']);
      $prettyurl          = '';
      if ($this->GetPreference('disable_prettyurls', 0) == 0) {
	$prettyurl = 'glossary';
	if ($this->GetPreference('show_single', '0') == '1') {
	  $prettyurl .= 'sing';
	}
	$prettyurl .= '/' . $row['term'];
	if (isset($opts['cat'])) {
	  $prettyurl .= '/' . $opts['cat'];
	}
	$prettyurl .= '/' . $returnid;
      }

      if ($this->GetPreference('process_smarty', '') == 'yes') {
	$def = $this->ProcessTemplateFromData($row['definition']);
      } else {
	$def = $row['definition'];
      }

      $onerow['definition'] = $def;
      $onerow['showdef']    = 0;
      if (isset($opts['tid']) && $opts['tid'] == $row['term_id']) {
	$onerow['showdef'] = 1;
	$selectedTerm      = $count;
      }
      if (isset($opts['term']) && $opts['term'] == $row['term']) {
	$onerow['showdef'] = 1;
	$selectedTerm      = $count;
      }

      if ($this->GetPreference('disable_prettyurls', 0) == 0) {
	$onerow['term'] = $this->CreateLink($id, 'show', $returnid, $row['term'], 
					    array_merge($linkparams, array('tid' => $row['term_id'])),
					    '', false, false, '', false, $prettyurl);
      } else {
	debug_display($onerow);
	if ($this->GetPreference('show_single', '0') == '1') {
	  $onerow['term'] = $this->CreateTermLink($onerow['name'], $onerow['safeterm'], $onerow['id'], $onerow['tip'], $onerow['definition'], false, '', true, $opts['cat']);
	} else {
	  $onerow['term'] = $this->CreateTermLink($onerow['name'], $onerow['safeterm'], $onerow['id'], $onerow['tip'], $onerow['definition'], true, '', false, $opts['cat']);
	}
      }

      array_push($entryarray, $onerow);
      $count++;
    }

    if (!isset($opts['show_nav']) || $opts['show_nav'] != '0') {
      $spining_chars = $this->GetPreference('spining_chars', '5') + 1;
      if ($selectedTerm > -1) {
	$start = ((integer) ($selectedTerm / $maxSize)) * $maxSize;
      } else if (isset($opts['start'])) {
	$start = $opts['start'];
      } else {
	$start = 0;
      }

      if ($start > 0) {
	$linkparams['start'] = max($start - $maxSize, 0);
	$prettyurl           = '';
	if ($this->GetPreference('disable_prettyurls', 0) == 0) {
	  $prettyurl = 'glossarynv/' . $linkparams['start'];
	  if (isset($opts['cat'])) {
	    $prettyurl .= '/' . $opts['cat'];
	  }
	  $prettyurl .= '/' . $returnid;
	}
	$this->smarty->assign('navprev', $this->CreateLink($id, 'show', $returnid, $this->Lang('prev'), $linkparams, '', false, false, '', false, $prettyurl));
      } else {
	$this->smarty->assign('prev', '');
      }

      $count = count($entryarray);

      $starts = array();
      $links  = array();
      if ($count > $maxSize) {
	// pass 1: load edge words into array
	for ($i = 0; $i < $count; $i += $maxSize) {
	  array_push($starts, $this->local_mb_ucfirst(mb_strtolower($entryarray[$i]['name'])));
	  array_push($links, ($i + 1));
	  if ($i + $maxSize - 1 < $count) {
	    array_push($starts, $this->local_mb_ucfirst(mb_strtolower($entryarray[$i + $maxSize - 1]['name'])));
	    array_push($links, ($i + 1));
	  }
	}
	if (($count % $maxSize) > 1) {
	  array_push($starts, $this->local_mb_ucfirst(mb_strtolower($entryarray[$count - 1]['name'])));
	  array_push($links, ($count - 1));
	}
      } else if ($count > 1) {
	array_push($starts, $this->local_mb_ucfirst(mb_strtolower($entryarray[0]['name'])));
	array_push($links, 1);
	array_push($starts, $this->local_mb_ucfirst(mb_strtolower($entryarray[$count - 1]['name'])));
	array_push($links, $count);
      }
      // pass 2: make 'em minimum difference

      $entrySize = count($starts);
      for ($i = 0; $i < $entrySize; $i++) {
	if ($i > 0 && $i % 2 == 0) {
	  if ($difLen > 1) {
	    $difLen--;
	  }
	} else {
	  $difLen = 1;
	}
	$flet = '';
	$llet = '';
	while ($flet == $llet && $difLen < $spining_chars) {
	  if (mb_strlen($starts[$i]) >= $difLen) {
	    $flet = mb_substr($starts[$i], 0, $difLen, $enc);
	  }
	  if ($i + 1 < $entrySize && mb_strlen($starts[min($i + 1, $entrySize - 1)]) >= $difLen) {
	    $llet = mb_substr($starts[min($i + 1, $entrySize - 1)], 0, $difLen, $enc);
	  }
	  $difLen++;
	}
	$starts[$i] = mb_substr($starts[$i], 0, $difLen - 1, $enc);
      }

      $navElements = array();
      for ($i = 0; $i < $entrySize; $i += 2) {
	$thisElement         = array();
	$thisElement['name'] = $starts[$i];
	if ($i < $entrySize - 1) {
	  $thisElement['name'] .= '-' . $starts[$i + 1];
	}
	if ($start >= $links[$i] && $start < $i + $maxSize) {
	  $thisElement['link'] = '';
	} else {
	  $linkparams['start'] = $links[$i] - 1;
	  $prettyurl           = '';
	  if ($this->GetPreference('disable_prettyurls', 0) == 0) {
	    $prettyurl = 'glossarynv/' . $linkparams['start'];
	    if (isset($opts['cat'])) {
	      $prettyurl .= '/' . $opts['cat'];
	    }
	    $prettyurl .= '/' . $returnid;
	  }
	  $thisElement['link'] = $this->CreateLink($id, 'show', $returnid, '', $linkparams, '', true, false, '', false, $prettyurl);
	}
	array_push($navElements, $thisElement);
      }

      if ($start + $maxSize < $count) {
	$linkparams['start'] = ($start + $maxSize);
	$prettyurl           = '';
	if ($this->GetPreference('disable_prettyurls', 0) == 0) {
	  $prettyurl = 'glossarynv/' . $linkparams['start'];
	  if (isset($opts['cat'])) {
	    $prettyurl .= '/' . $opts['cat'];
	  }
	  $prettyurl .= '/' . $returnid;
	}
	$this->smarty->assign('navnext', $this->CreateLink($id, 'show', $returnid, $this->Lang('next'), $linkparams, '', false, false, '', false, $prettyurl));
      } else {
	$this->smarty->assign('navnext', '');
      }
      $this->smarty->assign('navarray', $navElements);
    } else {
      $this->smarty->assign('navarray', array());
      $this->smarty->assign('navnext', '');
      $this->smarty->assign('navprev', '');
    }

    $entryarray = array_splice($entryarray, $start, $maxSize);
    $this->smarty->assign('title_section', $this->Lang('title_term_list'));

    if (isset($opts['cat'])) {
      $this->smarty->assign('cat', $opts['cat']);
    }

    $this->smarty->assign_by_ref('items', $entryarray);
    $this->smarty->assign('itemcount', count($entryarray));
  }
	
  public function InitializeFrontend()
  {
    $this->RestrictUnknownParams();
    $this->RegisterModulePlugin();

    $this->SetParameterType('glossarysing', CLEAN_STRING);
    $this->SetParameterType('tid', CLEAN_INT);
    $this->SetParameterType('cattid', CLEAN_INT);
    $this->SetParameterType('start', CLEAN_INT);
    $this->SetParameterType('term', CLEAN_STRING);
    $this->SetParameterType('cat', CLEAN_STRING);
    $this->SetParameterType('template', CLEAN_STRING);
    $this->SetParameterType('term_count', CLEAN_INT);
    $this->SetParameterType('show_nav', CLEAN_INT);
    $this->SetParameterType('no_pass_restriction', CLEAN_STRING);
    $this->SetParameterType('accept', CLEAN_STRING);
    $this->SetParameterType('target', CLEAN_STRING);
    $this->SetParameterType('keyword', CLEAN_STRING);
    $this->SetParameterType('sort', CLEAN_STRING);
    $this->SetParameterType('glossary', CLEAN_STRING);


    // For viewing a picture
    $this->RegisterRoute('/glossarysing\/(?P<tid>[0-9]+)\/(?P<returnid>[0-9]+)$/', 
			 array('action' => 'showsingle'));
    $this->RegisterRoute('/glossarysing\/(?P<term>[a-zA-Z]+)\/(?P<returnid>[0-9]+)$/', 
			 array('action' => 'showsingle'));
    $this->RegisterRoute('/glossarysing\/(?P<tid>[0-9]+)\/(?P<cat>[a-zA-Z]+)\/(?P<returnid>[0-9]+)$/', 
			 array('action' => 'showsingle'));
    $this->RegisterRoute('/glossary\/(?P<tid>[0-9]+)\/(?P<returnid>[0-9]+)$/',
			 array('action' => 'show'));
    $this->RegisterRoute('/glossary\/(?P<term>[\xe4\xc4\xf6\xd6\xfc\xdc\w ]+)\/(?P<returnid>[0-9]+)$/u', 
			 array('action' => 'show'));
    $this->RegisterRoute('/glossary\/(?P<term>[\xe4\xc4\xf6\xd6\xfc\xdc\w ]+)\/(?P<cat>.+?)\/(?P<returnid>[0-9]+)$/u', 
			 array('action' => 'show'));
    $this->RegisterRoute('/glossary\/(?P<tid>[0-9]+)\/(?P<cat>.+?)\/(?P<returnid>[0-9]+)$/',
			 array('action' => 'show'));
    $this->RegisterRoute('/glossarypg\/(?P<tid>[0-9]+)\/(?P<returnid>[0-9]+)$/',
			 array('action' => 'show'));
    $this->RegisterRoute('/glossarynv\/(?P<start>[0-9]+)\/(?P<cat>.+?)\/(?P<returnid>[0-9]+)$/',
			 array('action' => 'show'));
    $this->RegisterRoute('/glossarynv\/(?P<start>[0-9]+)\/(?P<returnid>[0-9]+)$/',
			 array('action' => 'show'));

    $smarty = cmsms()->GetSmarty();
    $smarty->register_block('glossary_terms',array('glossary_smarty','glossary_terms'));
  }

  public function InitializeAdmin()
  {
    $this->CreateParameter('action','show',$this->Lang('help_glossary_action'));
    //$this->CreateParameter('glossarysing', '', '');
    $this->CreateParameter('tid', '', $this->Lang('help_glossary_tid'));
    $this->CreateParameter('catid', '', $this->Lang('help_glossary_catid'));
    $this->CreateParameter('start', '', $this->Lang('help_glossary_start'));
    $this->CreateParameter('term', '', $this->Lang('help_glossary_term'));
    $this->CreateParameter('cat', '', $this->Lang('help_glossary_cat'));
    $this->CreateParameter('template', '', $this->Lang('help_glossary_template'));
    $this->CreateParameter('term_count', '', $this->Lang('help_glossary_term_count'));
    $this->CreateParameter('show_nav', '', $this->Lang('help_glossary_show_nav'));
    $this->CreateParameter('no_pass_restriction', '', $this->Lang('help_glossary_no_pass_restriction'));
    $this->CreateParameter('accept', '', $this->Lang('help_glossary_no_pass_restriction'));
    $this->CreateParameter('target', '', $this->Lang('help_glossary_target'));
    $this->CreateParameter('keyword', '', $this->Lang('help_glossary_keyword'));
    $this->CreateParameter('sort', 'alpha', $this->Lang('help_glossary_sort'));
    $this->CreateParameter('glossary', '', '');
  }

  protected function local_mb_ucfirst($string)
  {
    $string = mb_strtoupper(mb_substr($string, 0, 1)) . mb_substr($string, 1);
    return $string;
  }
}
?>
