<?php
/*
  MLSubscriptions module.

  Allows subscribing to and unsubscribing from Mailman mailing lists.
*/
class MLSubscriptions extends CMSModule
{
	function GetName()
	{
		return 'MLSubscriptions';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}


	function GetVersion()
	{
		return '0.1';
	}

	function GetHelp($lang='en_US') {
		return $this->Lang('help');
	}

	function getAuthor()
	{
		return 'Rimas Kudelis';
	}

	function getAuthorEmail()
	{
		return 'rq@akl.lt';
	}

	function IsPluginModule()
	{
		return true;
	}

	function GetDependencies()
	{
		return array("AjaxMadeSimple"=>"0.4.0", "CMSMailer"=>"2.0.2 ");
	}

	function AuthenticateAjaxMSCall($methodname) {
		if ($methodname == "Sendmail") return true;
		return false;
	}

	function InitializeAdmin() {
		$this->CreateParameter('robot', null, $this->Lang('help_robot'), false);
		$this->CreateParameter('action', null, $this->Lang('help_action'), true);
		$this->CreateParameter('suffix', null, $this->Lang('help_suffix'), true);
	}

	function DoAction($action, $id, $params, $returnid=-1)
	{
		switch ($action) {
			case 'subscribe':
				return $this->SubscribeForm($id, $params, $returnid);
				break;
			case 'unsubscribe':
				return $this->UnsubscribeForm($id, $params, $returnid);
				break;
			default:
				$ret = $this->SubscribeForm($id, $params, $returnid);
				$ret .= $this->UnsubscribeForm($it, $params, $returnid);
				return $ret;
				break;
		}
	}

	function SubscribeForm($id, $params, $returnid=-1)
	{
		$robot=filter_var($params['robot'], FILTER_VALIDATE_EMAIL);
		if($robot) {
			$ajax=$this->GetModuleInstance("AjaxMadeSimple");
			$ajax->SetupAjaxMS($id, $returnid);
			$ajax->RegisterAjaxRequester($this->GetName(), "Sendmail", "Subscribe" . $params['suffix'], "mailingListSubscribeResponse" . $params['suffix'], array("moduleaction" => "subscribe", "robot" => $robot), array("email" => "clear", "name" => "clear"));
			return '
				<form action="" method="post"' . $ajax->GetFormOnSubmit($this->GetName(), 'Subscribe' . $params['suffix']) . ' class="mailingListSubscribeForm">
					<div>
						<dl>
							<dt><label for="mailingListSubscribeEmailField' . $params['suffix'] . '">' . $this->Lang('email') . '</label></dt>
							<dd><input type="email" name="email" required="required" id="mailingListSubscribeEmailField' . $params['suffix'] . '" /></dd>
							<dt><label for="mailingListSubscribeNameField' . $params['suffix'] . '">' . $this->Lang('name') . '</label></dt>
							<dd><input type="text" name="name" id="mailingListSubscribeNameField' . $params['suffix'] . '" /></dd>
							<dt><input type="submit" value="' . $this->Lang('subscribe') . '" /></dt>
						</dl>
						<div id="mailingListSubscribeResponse' . $params['suffix'] . '" class="mailingListSubscribeResponse"></div>
					</div>
				</form>';
		} else {
			return '<p>'.$this->Lang('invalidaddress', array($params['robot'])).'</p>';
		}
	}

	function UnsubscribeForm($id, $params, $returnid=-1)
	{
		$robot=filter_var($params['robot'], FILTER_VALIDATE_EMAIL);
		if($robot) {
			$ajax=$this->GetModuleInstance("AjaxMadeSimple");
			$ajax->SetupAjaxMS($id, $returnid);
			$ajax->RegisterAjaxRequester($this->GetName(), "Sendmail", "Unsubscribe" . $params['suffix'], "mailingListUnsubscribeResponse" . $params['suffix'], array("moduleaction" => "unsubscribe", "robot" => $robot), array("email" => "clear"));
			return '
				<form action="" method="post"' . $ajax->GetFormOnSubmit($this->GetName(), 'Unsubscribe' . $params['suffix']) . ' class="mailingListUnsubscribeForm">
					<div>
						<dl>
							<dt><label for="mailingListUnsubscribeEmailField' . $params['suffix'] . '">' . $this->Lang('email') . '</label></dt>
							<dd><input type="email" name="email" required="required" id="mailingListUnsubscribeEmailField' . $params['suffix'] . '" /></dd>
							<dt><input type="submit" name="submit" value="' . $this->Lang('unsubscribe') . '" /></dt>
						</dl>
						<div id="mailingListUnsubscribeResponse' . $params['suffix'] . '" class="mailingListUnsubscribeResponse"></div>
					</div>
				</form>';
		} else {
			return '<p>'.$this->Lang('invalidaddress', array($params['robot'])).'</p>';
		}
	}
	

	/*---------------------------------------------------------
	Sendmail()
	Sends the (un)subscribe messages.
	---------------------------------------------------------*/
	function Sendmail($params)
	{
		$robot = filter_var($params['robot'], FILTER_VALIDATE_EMAIL);
		$email = filter_var($params['email'], FILTER_VALIDATE_EMAIL);
		$name = $params['name'];
		$action = filter_var($params['moduleaction'], FILTER_VALIDATE_REGEXP, array('options'=>array('regexp'=>'/^(un)?subscribe$/')));

		if(array_key_exists('lang', $params))
		{
			$this->curlang = $params['lang'];
		}

		if ($email) {
			if ($robot) {
				switch($action) {
					case 'subscribe':
						$successmsg = $this->Lang('subscribemailsent', array($email));
						break;
					case 'unsubscribe':
						$successmsg = $this->Lang('unsubscribemailsent', array($email));
						break;
					default:
						return '<p>'.$this->Lang('invalidaction', array($params['moduleaction'])).'</p>';
						break;
				}
	
				$subject = $action;
				$body = '';
				if ($name != '') {
					$headers = iconv_mime_encode('From', $name, array('input-charset' => 'UTF-8', 'output-charset' => 'UTF-8')) . ' <' . $email . ">";
				} else {
					$headers = 'From: ' . $email;
				}
				$sent = mail($robot, $subject, $body, $headers);

				if($sent)
				{
					return '<p>'.$successmsg.'</p>';
				}
				else
				{
					return '<p>'.$this->Lang('notsent').'</p>';
				}
			}
			else
			{
				return '<p>'.$this->Lang('invalidaddress', array($params['robot'])).'</p>';
			}
		}	
		else
		{
			return '<p>'.$this->Lang('invalidaddress', array($params['email'])).'</p>';
		}	
	}
}
?>
