<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

if ( !$this->CheckPermission('Gbook: Modify') )
{
	echo $this->ShowErrors(lang('needpermissionto', 'Gbook: Modify'));
	return;
}

if ( isset($params['cancel']) )
{
	$params = array('active_tab' => 'items');
	$this->Redirect($id, 'defaultadmin', '', $params);
}

if ( !isset($params['mode']) )
{
	$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

$smileys = Gbook_utils::GetSmileys(false);

switch ($params['mode'])
{
	case 'moveup':
		if( !isset($params['smileyid']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		$query = "UPDATE " . cms_db_prefix() . "module_gbook_smileys SET sort = sort + 1 WHERE sort = ?";
		$db->Execute($query, array($smileys[$params['smileyid']]['sort'] - 1));

		$query = "UPDATE " . cms_db_prefix() . "module_gbook_smileys SET sort = sort - 1 WHERE smiley_id = ?";
		$db->Execute($query, array($params['smileyid']));

		$params = array('active_tab' => 'smileys');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;

	case 'movedown':
		if( !isset($params['smileyid']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		$query = "UPDATE " . cms_db_prefix() . "module_gbook_smileys SET sort = sort - 1 WHERE sort = ?";
		$db->Execute($query, array($smileys[$params['smileyid']]['sort'] + 1));

		$query = "UPDATE " . cms_db_prefix() . "module_gbook_smileys SET sort = sort + 1 WHERE smiley_id = ?";
		$db->Execute($query, array($params['smileyid']));

		$params = array('active_tab' => 'smileys');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;

	case 'delete':
		if( !isset($params['smileyid']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}

		$query = "DELETE FROM " . cms_db_prefix() . "module_gbook_smileys WHERE smiley_id = ?";
		$db->Execute($query, array($params['smileyid']));
		
		@unlink('../modules/gbook/smileys/' . $smileys[$params['smileyid']]['smiley_file']);

		$params = array('active_tab' => 'smileys');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;

	case 'savesmileys':
		if( !isset($params['smiley_id']) && !is_uploaded_file($_FILES[$id.'addsmiley']['tmp_name']) )
		{
			$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
			$this->Redirect($id,'defaultadmin','',$params);
			return;
		}
		
		if( isset($params['smiley_id']) )
		{
			foreach ( $params['smiley_id'] as $key => $smiley_id )
			{
				$query = "UPDATE " . cms_db_prefix() . "module_gbook_smileys SET smiley_code = ?, active = ?, sort = ? WHERE smiley_id = ?";
				$db->Execute($query, array(trim($params['smiley_code'][$key]), (empty($params['active'][$smiley_id])) ? 0 : 1, $key, $smiley_id));
			}
		}
		
		if ( is_uploaded_file($_FILES[$id.'addsmiley']['tmp_name']) )
		{
			$allowedext = array('jpg','jpeg','gif','png');
			$rawfilename = $_FILES[$id.'addsmiley']['name'];
			$filename = str_replace('-', '', munge_string_to_url(substr($rawfilename, 0, strrpos($rawfilename, '.'))));
			$fileext = strtolower(substr($rawfilename, strrpos($rawfilename, '.') + 1));
			if ( in_array($fileext, $allowedext) )
			{
				if ( cms_move_uploaded_file($_FILES[$id.'addsmiley']['tmp_name'], '../modules/gbook/smileys/' . $filename . '.' . $fileext) )
				{
					$query = "INSERT INTO ".cms_db_prefix()."module_gbook_smileys (smiley_file, smiley_code, sort, active) VALUES (?,?,?,?)";
					$result = $db->Execute($query, array($filename . '.' . $fileext, '', count($smileys), 0));
				}
			}
		}
		$params = array('active_tab' => 'smileys');
		$this->Redirect($id, 'defaultadmin', '', $params);
		break;
}


$params = array('errors' => lang('missingparams'), 'active_tab' => 'smileys');
$this->Redirect($id,'defaultadmin','',$params);
?>
