<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

// Get gbook properties
$alias = empty($params['alias']) ? $this->GetPreference('defaultgbook') : $params['alias'];
$gbooks = Gbook_utils::GetGbooks($alias);
$gbook = $gbooks[0];
$smarty->assign_by_ref('gbook_props', $gbook);


// pagination
$params['gbpage'] = empty($params['gbpage']) ? 1 : $params['gbpage'];
$pages = ceil($gbook['entries'] / $gbook['entries_page']);
$start = (($params['gbpage'] - 1) * $gbook['entries_page']) + 1;


// get template
$template = $this->GetPreference('default_summary_template');
if ( !empty($params['template']) && $params['template'] != $template )
{
	$template = 'summary_tpl_' . $params['template'];
	$linkparams['template'] = $template;
}


// get cache
$cache_id = '|gb'.md5($gbook['gbook_id'].'-'.$params['gbpage'].'-'.$gbook['entries'].'-'.$gbook['entries_page']);
$compile_id = '';
global $CMS_VERSION;
if( $CMS_VERSION >= '1.11' && $smarty->isCached($this->GetDatabaseResource($template),$cache_id,$compile_id) ) 
{
	// Display cached template
	echo $smarty->fetch($this->GetDatabaseResource($template),$cache_id,$compile_id);
}
else
{
	// get gbook entries
	$entries = Gbook_utils::GetEntries($gbook['gbook_id'], $start, $gbook['entries_page']);
	$smarty->assign_by_ref('gbook_entries', $entries);


	// pagination links
	$prettyurl = 'gbook/' . $gbook['gbook_id'] . '-';
	$linkparams['alias'] = $gbook['gbook_id'];
	$pagelinks = array();
	for ($i = 1; $i <= $pages; $i++) {
		$linkparams['gbpage'] = $i;
		$pagelinks[$i] = $this->CreateFrontendLink($id, $returnid, 'default', '', $linkparams, '', true, true, '', false); //, $prettyurl . $i . '/' . $returnid);
	}
	$smarty->assign_by_ref('gbook_pagelinks', $pagelinks);
	$smarty->assign('gbook_currentpage', $params['gbpage']);
	$smarty->assign('gbook_entrieslabel', $this->Lang('entries'));
	
	if( $CMS_VERSION >= '1.11' )
	{
		echo $smarty->fetch($this->GetDatabaseResource($template),$cache_id,$compile_id);
	}
	else
	{
		echo $this->ProcessTemplateFromDatabase($template);	
	}
}
?>