<?php
#-------------------------------------------------------------------------
# Module: Gbook
# Author: Jos (josvd@live.nl)
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/gbook/
#-------------------------------------------------------------------------


$images = glob("../modules/gbook/smileys/*.{jpg,JPG,png,PNG}", GLOB_BRACE);
$images = str_replace('../modules/gbook/smileys/', '', $images);

$items = Gbook_utils::GetSmileys(false);

$itemarray = array();
$i = 0;
foreach ($items as $item)
{
	$onerow = new stdClass();

	$onerow->smiley_id = $this->CreateInputHidden($id, 'smiley_id[]', $item['smiley_id']);
	$onerow->smiley_file = $item['smiley_file'];
	$onerow->smiley_path = '../' . $item['smiley_path'];
	$onerow->smiley_code = $this->CreateInputText( $id, 'smiley_code[]', $item['smiley_code'], 6 );
	$onerow->active = $this->CreateInputCheckbox($id, 'active[' . $item['smiley_id'] . ']', 1, $item['active']);
	$onerow->sort = $item['sort'];
	if ( $i > 0 )
	{
		$onerow->moveup = $this->CreateLink($id, 'editsmileys', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-u.gif', lang('up'),'','','systemicon'), array('smileyid' => $item['smiley_id'], 'mode' => 'moveup'));
	}
	else
	{
		$onerow->moveup = '';
	}

	if ( $i < count($items) - 1 && count($items) > 1 )
	{
		$onerow->movedown = $this->CreateLink($id, 'editsmileys', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-d.gif', lang('down'),'','','systemicon'), array('smileyid' => $item['smiley_id'], 'mode' => 'movedown'));
	}
	else
	{
		$onerow->movedown = '';
	}
	$onerow->delete = $this->CreateLink($id, 'editsmileys', $returnid,
					  $themeObject->DisplayImage('icons/system/delete.gif', lang('delete'), '', '', 'systemicon'),
					  array ('smileyid' => $item['smiley_id'], 'mode' => 'delete'), $this->Lang('areyousure'));
	array_push($itemarray, $onerow);
	$i++;
}

$smarty->assign_by_ref('items', $itemarray);


$smarty->assign('formstart', $this->CreateFormStart ($id, 'editsmileys', $returnid, 'post', 'multipart/form-data', false, '', array('mode' => 'savesmileys')));
$smarty->assign('formend', $this->CreateFormEnd());

$smarty->assign('smiley', $this->Lang('smiley'));
$smarty->assign('code', lang('code'));
$smarty->assign('active', lang('active'));

$smarty->assign('prompt_addsmiley', $this->Lang('addsmiley'));
$smarty->assign('addsmiley', $this->CreateInputFile ($id, 'addsmiley', '', 20));

$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang ('cancel')));

// Display the populated template
echo $this->ProcessTemplate ('adminsmileys.tpl');

?>