<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function supports the back end for the module Service Desk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class sdbe_utils
{

	/**
	 * This function retrieves the email of the logged in user
	 * @param integer userid the internally used user id
	 * @return mixed false if not found, email address if found
	 */
	function GetFEUUseremail($userid)
	{
		$useremail = false;
		$modops = cmsms()->GetModuleOperations();
		$feu = $modops->get_module_instance('FrontEndUsers');

		if( !$feu ) return false;
		$useremail = $feu->GetEmail($userid);
		return $useremail;
	}

	/**
	 * This function retrieves the name of the logged in user
	 * @param integer userid the internally used user id
	 * @return mixed false if not found, user name if found
	 */
	function GetFEUUsername($userid)
	{
		$username = false;
		$modops = cmsms()->GetModuleOperations();
		$feu = $modops->get_module_instance('FrontEndUsers');

		if( !$feu ) return false;
		$username = $feu->GetUserName($userid);
		return $username;
	}

	/**
	 * A function to return all information of an incident in an array
	 * @param integer incident_id the internally used incident id
	 * @return mixed either false if not found or array with information
	 */	
	function GetIncidentDetail($incident_id = -1)
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$row = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents 
			WHERE incident_id = ?';
		$row = $db->GetRow($query, array($incident_id));
		
		if ($row) {
			return $row;
		}
		else {
			return false;
		}
	}

	/**
	 * A function to return all possible owners in an array
	 * @return array list of names of internal users (not FEU users)
	 */	
	function GetListOwners()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$ownerlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'users ORDER BY first_name';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow()) {
			if ($row['first_name'] . $row['last_name'] == '') {
				$ownerlist[$row['username']] = $row['user_id'];
			}
			else {
				$ownerlist[$row['first_name'].' '.$row['last_name']] = $row['user_id'];
			}
		}

		return $ownerlist;
	}

	/**
	 * Send mail to requestor of the incident 
	 *
	 * @param integer incident_id The internal id to the incident
	 * @param boolean Mail sent or not
	 */
	function SendMailIncident($incident_id = -1)
	{
		$db = cmsms()->GetDb();
		if ($incident_id == -1) return false;
		// Establish connections to other module functionality
		$modops = cmsms()->GetModuleOperations();
		$cmsmailer = $modops->get_module_instance('CMSMailer');
		$mod = cms_utils::get_module('ServiceDesk');
		$smarty = cmsms()->GetSmarty();

		// Retrieve the incident
		$row = array();
		$row = sdbe_utils::GetIncidentDetail($incident_id);
		// Set the variables for the template
		$smarty->assign('createdate',$row['create_date']);
		$smarty->assign('description',$row['description']);
		$smarty->assign('incident_id',$row['incident_id']);
		$smarty->assign('product',$row['product']);
		$smarty->assign('yourref',$row['requestor_ref']);
		$useremail = sdbe_utils::GetFEUUseremail($row['requestor_id']);
		$username = sdbe_utils::GetFEUUsername($row['requestor_id']);
		$smarty->assign('name',$username);
		$smarty->assign('priority',$row['priority']);
		$smarty->assign('detail_description',cms_html_entity_decode($row['detail_description']));
		// If there is a mailaddress of the requestor, use it to confirm incident logging
		if( $useremail != '' )
		{
			// Make sure that there is only one mail send out
			$cmsmailer->ClearAddresses();
			// Prepare the mail and send it
			$cmsmailer->AddAddress( $useremail );
			$cmsmailer->SetSubject( $mod->GetPreference('receivedincidentmailsubject',$mod->Lang('subjectnewincident')));
			if ($mod->GetPreference('sendmailincidenthtml') == 1) {
				$cmsmailer->IsHTML( true );
			}
			else {
				$cmsmailer->IsHTML( false );
			}
			
			$body = $mod->ProcessTemplateFromDatabase('receiveincidentmailtemplate');
			$cmsmailer->SetBody( $body );
			$cmsmailer->Send();
		}

		return;
	}

	/**
	 * Send mail to owner of the incident 
	 *
	 * @param integer incident_id The internal id to the incident
	 * @param boolean Mail sent or not
	 */
	function SendMailIncident2Admin($incident_id = -1)
	{
		$db = cmsms()->GetDb();
		if ($incident_id == -1) return false;
		// Establish connections to other module functionality
		$modops = cmsms()->GetModuleOperations();
		$cmsmailer = $modops->get_module_instance('CMSMailer');
		$mod = cms_utils::get_module('ServiceDesk');
		$smarty = cmsms()->GetSmarty();

		// Retrieve the incident
		$row = array();
		$row = sdbe_utils::GetIncidentDetail($incident_id);
		// Set the variables for the template
		$smarty->assign('createdate',$row['create_date']);
		$smarty->assign('description',$row['description']);
		$smarty->assign('incident_id',$row['incident_id']);
		$smarty->assign('product',$row['product']);
		$smarty->assign('yourref',$row['requestor_ref']);
		$username = sdbe_utils::GetFEUUsername($row['requestor_id']);
		$smarty->assign('name',$username);
		$smarty->assign('priority',$row['priority']);
		$smarty->assign('detail_description',cms_html_entity_decode($row['detail_description']));
		// Retrieve info from owner of the new incident
		$query = 'SELECT * FROM '.cms_db_prefix().'users WHERE user_id = ?';
		$result = $db->GetRow($query, array($row['owner_id']));
		$owneremail = '';
		if ($result) {
			$owneremail = $result['email'];
		}
		
		// If there is an email address of owner, use it to send the 'new icident' mail
		if( $owneremail != '' )
		{
			// Make sure that there is only one mail send out
			$cmsmailer->ClearAddresses();
			// Prepare the mail and send it
			$cmsmailer->AddAddress( $owneremail );
			$cmsmailer->SetSubject( $mod->GetPreference('newincidentmailsubject2admin',$this->Lang('subjectnewincident2admin')));
			if ($mod->GetPreference('sendmailincident2adminhtml') == 1) {
				$cmsmailer->IsHTML( true );
			}
			else {
				$cmsmailer->IsHTML( false );
			}
			
			$body = $mod->ProcessTemplateFromDatabase('newincidentmail2admintemplate');
			$cmsmailer->SetBody( $body );
			$cmsmailer->Send();
		}

		return;
	}

}

?>