<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function supports the back end for the module Service Desk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class sdattr_utils
{
	
	/*---------------------------------------------------------
	  IncidentFileDelete()
	  This function deletes earlier uploaded files from the uploads
	  directory. It is nearly the same as the IncidentImageDelete function.
	  Both functions are however included to allow easy change for 
	  either types.
	 ---------------------------------------------------------*/	 
	function IncidentFileDelete($id,$record_id,$value)
	{
		$gCms = cmsms();
		$config =& $gCms->GetConfig();
		$destdir = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id);
		if( !is_dir($destdir) )	{
			return true;
		}
		
		$fn = cms_join_path($destdir,$value);
		if( file_exists($fn) ) {
			@unlink($fn);
			if( file_exists($fn) ) return false;
		}
		
		return true;
	}

	/*---------------------------------------------------------
	  IncidentFileUpload()
	  This function uploads files to the uploads directory.
	  It is nearly the same as the IncidentImageUpload function.
	  Both functions are however included to allow easy change for 
	  either types.
	 ---------------------------------------------------------*/	 
	function IncidentFileUpload($id, $name, $record_id,	&$value, &$result)
	{
		$gCms = cmsms();
		$config =& $gCms->GetConfig();
		
		$destdir = cms_join_path($config['uploads_path'],$this->GetName());
		if( !is_dir($destdir) )
		{
			$res = @mkdir( $destdir );
			if( $res === FALSE ) {
				$result = $this->Lang('error_mkdir').': '.$destdir;
				return false;
			}
		}

		$destdir = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id);
		if( !is_dir($destdir) )
		{
			$res = @mkdir( $destdir );
			if( $res === FALSE ) {
				$result = $this->Lang('error_mkdir').': '.$destdir;
				return false;
			}
		}
		// Validate the size of the object to upload
		if( $_FILES[$id.$name]['size'] > $config['max_upload_size'] ) {
			$result = $this->Lang('error_filesize');
			return FALSE;
		}
		$filename = basename($_FILES[$id.$name]['name']);
		if ($filename == '') {
			return FALSE;
		}
		$dest = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id,$filename);
		$value = $filename;
		
		// Get the files extension
		$ext = substr(strrchr($filename, '.'), 1);
		// Compare it against the 'allowed extentions'
		$exts = explode(',',$this->GetPreference('allowedfiletypes',''));
		if( !in_array( $ext, $exts ) )  {
			$result = $this->Lang('error_invalidfiletype', $filename);
			return FALSE;
		}
		if( @cms_move_uploaded_file($_FILES[$id.$name]['tmp_name'], $dest) === FALSE ) {
			$result = $this->Lang('error_movefile',$dest);
			return FALSE;
		}
		
		return $filename;
	}
		
	function IncidentImageDelete($id,$record_id,$value)
	{
		$gCms = cmsms();
		$config =& $gCms->GetConfig();
		$destdir = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id);
		if( !is_dir($destdir) )	{
			return true;
		}
		
		$fn = cms_join_path($destdir,$value);
		if( file_exists($fn) ) {
			@unlink($fn);
			if( file_exists($fn) ) return false;
		}
		
		$fn = cms_join_path($destdir,'thumb_'.$value);
		if( file_exists($fn) ) {
			@unlink($fn);
			if( file_exists($fn) ) return false;
		}
		
		return true;
	}

	function IncidentImageUpload($id, $name, $record_id,	&$value, &$result)
	{
		$gCms = cmsms();
		$config =& $gCms->GetConfig();
		
		$destdir = cms_join_path($config['uploads_path'],$this->GetName());
		if( !is_dir($destdir) )
		{
			$res = @mkdir( $destdir );
			if( $res === FALSE ) {
				$result = $this->Lang('error_mkdir').': '.$destdir;
				return false;
			}
		}

		$destdir = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id);
		if( !is_dir($destdir) )
		{
			$res = @mkdir( $destdir );
			if( $res === FALSE ) {
				$result = $this->Lang('error_mkdir').': '.$destdir;
				return false;
			}
		}
		// Validate the size of the object to upload
		if( $_FILES[$id.$name]['size'] > $config['max_upload_size'] ) {
			$result = $this->Lang('error_filesize');
			return FALSE;
		}
		$filename = basename($_FILES[$id.$name]['name']);
		if ($filename == '') {
			return FALSE;
		}
		$dest = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$record_id,$filename);
		$value = $filename;
		
		// Get the files extension
		$ext = substr(strrchr($filename, '.'), 1);
		// Compare it against the 'allowed extentions'
		$exts = explode(',',$this->GetPreference('allowedimagetypes',''));
		if( !in_array( $ext, $exts ) ) {
			$result = $this->Lang('error_invalidimagetype', $filename);
			return FALSE;
		}
		if( @cms_move_uploaded_file($_FILES[$id.$name]['tmp_name'], $dest) === FALSE ) {
			$result = $this->Lang('error_movefile',$dest);
			return FALSE;
		}
		
		return $filename;
		
	}
	
	function IncidentFolderDelete($incident_id)
	{
		$gCms = cmsms();
		$config =& $gCms->GetConfig();
		$destdir = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$incident_id);
		if( !is_dir($destdir) )	{
			return false;
		}
		$dir = opendir($destdir);
		while (($file = readdir($dir)) !== false) {
			if ($file != '.' && $file !='..') {
				$fn = cms_join_path($config['uploads_path'],$this->GetName(),'Incident_'.$incident_id,$file);
				$result = @unlink($fn);
		  	}
	  	}

		closedir($dir);
		// Remove the now cleared directory
		if(!rmdir($destdir)) {
			return false;
		}		
		return true;
	}

	/**
	 * Merge two arrays of hashes based on certain keys 
	 *
	 * @param array arr1  The primary array
	 * @param array arr2  The array to be merged
	 * @param string key1   The key field in the first array
	 * @param string key2   The key field in the second array
	 */
	function MergeByKeys($arr1,$arr2,$key1 = 'name',$key2 = 'name')
	{
		if( !is_array( $arr1 ) || !is_array( $arr2 ) )
		{
			return;
		}
		$xxresult = array();
		foreach( $arr1 as $a1 )
		{
			$key1val = $a1[$key1];
			$found = false;
			foreach( $arr2 as $a2 )
			{
				if( $a2[$key2] == $key1val )
				{
					// Found an item to merge
					$xxresult[] = array_merge($a1,$a2);
					$found = true;
					break;
				}
			}
			
			if( !$found )
			{
				$xxresult[] = $a1;
			}
		}
		
		return $xxresult;
	}

}

?>