<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown
#
# This function supports adding incidents
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Initialize new incident (Fields on front end)
$product = '';
$description = '';
$usedcategory = 0;
$requestor_ref = '';
$detail_description = '';
$usedpriority = '5';
// Initialize fields not on front end
$status = $this->GetPreference('defaultstatus', 'OP');
$sendmail = 0;
$owner_id = $this->GetPreference('defaultowner', 0);
$usedpriorityseq = 5;
$createdate = trim($db->DBTimeStamp(time()), "'");
$do_send_email = false;
$do_redirect = false;
$servicedeskversion = $this->GetPreference('servicedeskversion');

// Handle the page to go to after cancel or submit.
$dest_page = $returnid;
$tmp = $this->GetPreference('fesubmit_redirect');
if( !empty($tmp) )
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($tmp);
	if (isset($node))
	{
		$tmp2 =& $node->GetContent();
		if (isset($tmp2))
		{
			$dest_page = $tmp2->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($tmp);
		if (isset($node))
		{
			$dest_page = $tmp;
		}
	}
}

if (isset($params['cancel'])) {
    $this->RedirectContent($dest_page);
}
$useremail = '';
// Make sure that requestor is logged in, so we have an internal number as well
if( $usedrequestor == '' )
{
	$usedrequestor = $this->GetFEUUserid();
	$useremail = sdbe_utils::GetFEUUseremail($usedrequestor);
	$username = sdbe_utils::GetFEUUsername($usedrequestor);
}

if( $usedrequestor <= 0  ) 
{
	$this->RedirectContent($dest_page);
}

// Handle the entry done by the requestor
if( isset( $params['submit'] ) )
{
	if (isset($params['description']) )
	{
		$description = cms_html_entity_decode($params['description']);
	}

	if (isset($params['product']))
	{
		$product = cms_html_entity_decode($params['product']);
	}
	
	if (isset($params['cat_id']))
	{
		$usedcategory = $params['cat_id'];
	}

		if (isset($params['requestor_ref']))
	{
		$requestor_ref = cms_html_entity_decode($params['requestor_ref']);
	}
	
	if (isset($params['detail_description']))
	{
		$detail_description = cms_html_entity_decode($params['detail_description']);
	}

		if (isset($params['priority']))
	{
		$usedpriority = $params['priority'];
	}


	// Validate all the field values
	$error = false;

	if( $description == '' )
	{
		$error = true;
		$smarty->assign('error',$this->Lang('noincidentdescgiven'));
	}

	if( $error == false )
	{

		// Generate a new incident number
		$incident_id = $db->GenID(cms_db_prefix()."module_servicedesk_incidents_seq");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incidents (incident_id, description, product, cat_id,
			requestor_id, status, sendmail, requestor_ref, detail_description, owner_id, priority, priorityseq, create_date,
			modified_date, start_date, end_date)
			VALUES (?,?,?,?,
				?,?,?,?,?,?,?,?,?,
				?,?,?)';
		$db->Execute($query, array($incident_id, $description, $product, $usedcategory, 
			$usedrequestor, $status, $sendmail, $requestor_ref, $detail_description, $owner_id, $usedpriority, $usedpriorityseq,
			$createdate, NULL, $createdate, NULL));

		if ($servicedeskversion == 'gold') {
			// Insert the attributes for this incident
			// First remove the existing attributes of the incident
			$query = 'DELETE FROM '.cms_db_prefix().'module_servicedesk_incident_attributes 
				WHERE incident_id = ?';
			$db->Execute($query, array((int)$params['incident_id']));
			// Use only filled fields
			foreach ( $params as $key => $value ) {
				if( !preg_match('/fld_/', $key ) )
				{
					continue;
				}
				$value = trim($value);
				
				// Adjust the key to get the field name
				$fldname = substr($key,4);
				if( !isset($params['info_'.$fldname]) )
				{
					// Something went wrong, trigger error
					continue;
				}
				list($fldtype,$fldid) = explode(',',trim($params['info_'.$fldname]));
				$pass = true;
				switch( $fldtype )
					{
					case 'image':
						{
							$res = true;
							if( isset( $params['del_'.$fldname] ) ) {
								$res = sdattr_utils::IncidentImageDelete($id, $incident_id, $value);
								// Now that image has been deleted, bail out otherwise image will be loaded again
								$value = '';
								break;
							}
							if( !$res )	{
								$pass = false;
								$errors[] = $this->Lang('error_filedelete');
							}
							else {
								$t_value = '';
								$t_result = '';
								$res = sdattr_utils::IncidentImageUpload($id, $key, $incident_id,
									$t_value,$t_result);
								if( !$res && !empty($result))
								{
									$pass = false;
									$errors[] = $t_result;
								}
								if( $res && !empty($t_value) )
								{
									$value = $t_value;
								}
							}
						}
						break;
					
					case 'file':
						{
							$res = true;
							if( isset( $params['del_'.$fldname] ) ) {
								$res = sdattr_utils::IncidentFileDelete($id, $incident_id, $value);
								// Now that file has been deleted, bail out otherwise file will be loaded again
								$value = '';
								break;
							}
							
							if( !$res ) {
								$pass = false;
								$errors[] = $this->Lang('error_filedelete');
							}
							else {
								$t_value = '';
								$t_result = '';
								$res = sdattr_utils::IncidentFileUpload($id, $key, $incident_id,
									$value,$result);
								if( !$res && !empty($result))
								{
									$pass = false;
									$errors[] = $result;
								}
								if( $res && !empty($t_value) )
								{
									$value = $t_value;
								}
							}
						}
						break;
					}
				
				// Save the found value
				if( $pass && !empty($value))
				{
					$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incident_attributes
					 (incident_id, attr_id, value)
						VALUES (?,?,?)';
					$dbr = $db->Execute( $query, array( $incident_id, $fldid, $value) );
				}	
			}
		}

		// Send an email
		$do_send_email = true;
		$do_redirect = true;

		// Send an event
		@$this->SendEvent('IncidentAdded', array(
				'incident_id' => $incident_id, 
				'description' => $description, 
				'product' => $product, 
				'requestor_ref' => $requestor_ref, 
				'detail_description' => $detail_description, 
				'status' => $status, 
				'createdate' => $createdate));
	}
}
if ($servicedeskversion == 'gold') {
	// Add attributes to the form
	$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_attributes';
	$query .= ' WHERE public = 1';
	$attributedefs = $db->GetArray($query);
	if( isset($params['incident_id']) ) {
		// Connect any available values of the attributes
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incident_attributes
			WHERE incident_id = ?';
		$attributevals = $db->GetArray($query,array((int)$params['incident_id']));
		if( $attributevals ) {
			$tmp = sdattr_utils::MergeByKeys($attributedefs,$attributevals,'attr_id','attr_id');
			$attributedefs = $tmp;
		}
	}
	
	$attributes = array();
	foreach( $attributedefs as $oneattribute )
	{
		if( !isset($oneattribute['value']) ) $oneattribute['value'] = '';
		//sdattr_utils::setAttrParameterType($oneattribute['name']);
		$oneattribute['hidden'] = $this->CreateInputHidden($id,'info_'.$oneattribute['name'],
				 $oneattribute['type'].','.$oneattribute['attr_id']);
	 
		switch( $oneattribute['type'] ) {
			case 'textbox':
				$size = min(50,$oneattribute['max_length']);
				$oneattribute['field'] = $this->CreateInputText($id,'fld_'.$oneattribute['name'],
					$oneattribute['value'],$size,$oneattribute['max_length']);
				break;
			case 'textarea':
				$oneattribute['field'] = $this->CreateTextArea(true,$id,$oneattribute['value'],'fld_'.
					$oneattribute['name']);
				break;
			case 'checkbox':
				$oneattribute['field'] = $this->CreateInputCheckbox($id,'fld_'.$oneattribute['name'],
					1,$oneattribute['value']);
				break;
			case 'dropdown':
				{
					$tmp = explode("\n",$oneattribute['options']);
					$tmp2 = array();
					foreach( $tmp as $one )
					{
						$one = trim($one);
						$tmp2[$one] = $one;
					}
					$oneattribute['field'] = $this->CreateInputDropdown($id,'fld_'.$oneattribute['name'],
						$tmp2,-1,$oneattribute['value']);
				}
				break;
			case 'image':
				if( !empty($oneattribute['value']) ) {
					$oneattribute['display_value'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$oneattribute['value'];
					$oneattribute['delete_attribute'] = $this->CreateInputCheckbox($id,'del_'.
						$oneattribute['name'],1,0);
				}
				$oneattribute['field'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
					$oneattribute['value']).$this->CreateFileUploadInput($id,'fld_'.$oneattribute['name'],
						'',30);
				break;
			case 'file':
				if( !empty($oneattribute['value']) ) {
					$oneattribute['display_value'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$oneattribute['value'];
					$oneattribute['delete_attribute'] = $this->CreateInputCheckbox($id,'del_'.$oneattribute['name'],1,0);
				}
				$oneattribute['field'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$this->CreateFileUploadInput($id,'fld_'.$oneattribute['name'],'',30);
				break;
		}
		$attributes[] = $oneattribute;
	}
	if( count($attributes) ) {
	  $smarty->assign('attributes',$attributes);
	  $smarty->assign('countattributes', count($attributes));
	
	}
}
// Prepare a list of categories
$categorylist = array();
$categorylist = $this->GetListCategories();

// Prepare the various priorities
$prioritydropdown = array();
$prioritydropdown = $this->GetListPriorities();

// Prepare the form
$smarty->assign('startform',$this->CreateFrontEndFormStart($id,$returnid,'fesubmit','post','multipart/form-data'));
$smarty->assign('endform',$this->CreateFormEnd());
$this->smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 80, 80, 'class="defaultfocus"'));
$this->smarty->assign('producttext', $this->Lang('product'));
$this->smarty->assign('productinput', $this->CreateInputText($id, 'product', $product, 20, 20));
$this->smarty->assign('categorytext', $this->Lang('category'));
$this->smarty->assign('categoryinput', $this->CreateInputDropdown($id, 'cat_id', $categorylist, -1, $usedcategory));
$this->smarty->assign('requestor_reftext', $this->Lang('requestor_reference'));
$this->smarty->assign('requestor_refinput', $this->CreateInputText($id, 'requestor_ref', $requestor_ref, 25, 25));
$this->smarty->assign('detaildesctext', $this->Lang('detaildescription'));
$this->smarty->assign('detaildescinput', $this->CreateTextArea(false,
	$id, $detail_description, 'detail_description', '', '', '', '', '80', '3'));
$this->smarty->assign('prioritytext', $this->Lang('priority'));
$this->smarty->assign('priorityinput', $this->CreateInputDropdown($id, 'priority', $prioritydropdown, -1, $usedpriority));

$this->smarty->assign('hidden', '');
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));

$template = $this->GetPreference('current_form_template');
if (isset($params['formtemplate']))
  {
    $template = 'form_'.$params['formtemplate'];
  }
echo $this->ProcessTemplateFromDatabase($template);

if( $do_send_email == true )
{
 	// This needs to be done after the form is generated
 	// because we use some of the same smarty variables
 	$cmsmailer =& $this->GetModuleInstance('CMSMailer');
 	if( $cmsmailer )
 	{
		// Check if confirmation mail is to be send
		if ( $this->GetPreference('sendmailincident') ) {
			sdbe_utils::SendMailIncident($incident_id);
		}

		// Check if mail for the back office is requested
		if ( $this->GetPreference('sendmailincident2admin') ) {
			sdbe_utils::SendMailIncident2Admin($incident_id);
		}
 	}
}

if( $do_redirect )
  {
    $this->RedirectContent($dest_page);
  }

?>