<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports adding statusses
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
 
$db = cmsms()->GetDb();

if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use ServiceDesk')));
	return;
}

$status = '';
if (isset($params['status'])) {
	$status = strtoupper($params['status']);
}

$description = '';
if (isset($params['description'])) {
	$description = $params['description'];
}

$sendmail = 0;
if (isset($params['sendmail'])) {
	$sendmail = $params['sendmail'];
}

$mailsubject = '';
if (isset($params['mailsubject'])) {
	$mailsubject = $params['mailsubject'];
}

$mailbody = '';
if (isset($params['mailbody'])) {
	$mailbody = cms_html_entity_decode($params['mailbody']);
}
$htmlmail = 0;
if (isset($params['htmlmail'])) {
	$htmlmail = $params['htmlmail'];
}

if (isset($params['cancel'])) {
	$params = array('active_tab' => 'statusses');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$desc = '';
if (isset($params['description']))
{
	$desc = $params['description'];
	if ($desc != '')
	{
		$stat_id = $db->GenID(cms_db_prefix()."module_servicedesk_statusses_seq");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_statusses (stat_id, status, description, 
			sendmail, mailsubject, mailbody, htmlmail)
			VALUES (?,?,?,?,?,?,?)';
		$db->Execute($query, array($stat_id, $status, $description, $sendmail, 
			$mailsubject, $mailbody, $htmlmail));
		
		$params = array('tab_message'=> 'statusadded', 'active_tab' => 'statusses');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		echo $this->ShowErrors($this->Lang('nostatdescgiven'));
	}
}

// Prepare a list of possible values for the user to use in the template
$subjectparms = array();
$subjectparms = $this->GetPossibleMailVars('statussubject');
$mailparms = array();
$mailparms = $this->GetPossibleMailVars('statusbody');

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'addstatus', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('statustext', $this->Lang('status'));
$this->smarty->assign('statusinput', $this->CreateInputText($id, 'status', $status, 2, 2, 'class="defaultfocus"'));
$this->smarty->assign('descriptiontext', $this->Lang('statusdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 40, 80));
$this->smarty->assign('sendmailtext', $this->Lang('sendmail'));
$this->smarty->assign('sendmailinput', $this->CreateInputCheckbox($id, 'sendmail', true, $sendmail));
// Make it possible to prepare mail settings to send mail to requestor once status changed
$this->smarty->assign('fieldset_mailtext', $this->Lang('title_fieldset_mail'));
$this->smarty->assign('subjecttext', $this->Lang('title_mail_subject'));
$this->smarty->assign('subjectinput', $this->CreateInputText($id, 'mailsubject', $mailsubject, 50, 50));
$this->smarty->assign('mail_templatetext', $this->Lang('title_mail_template'));
$this->smarty->assign('mail_templateinput',$this->CreateTextArea($this->GetPreference('enablemailwysiwyg', true), $id, $mailbody,'mailbody'));
$this->smarty->assign('htmlmailtext', $this->Lang('title_htmlmail'));
$this->smarty->assign('htmlmailinput', $this->CreateInputCheckbox($id, 'htmlmail', true, $htmlmail));

$this->smarty->assign('title_parms_to_use', $this->Lang('title_parms_to_use'));
$this->smarty->assign('parametersshow', $this->Lang('parametersshow'));
$this->smarty->assign('parametershide', $this->Lang('parametershide'));
$this->smarty->assign('subjectnames', $subjectparms);
$this->smarty->assign('names', $mailparms);

$this->smarty->assign('hidden', '');
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editstatus.tpl');
?>