<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function supports adding statusses
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
 
$db = cmsms()->GetDb();

if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use ServiceDesk')));
	return;
}

$incident_id = '';
if (isset($params['incident_id']))
{
	$incident_id = ($params['incident_id']);
}

$note = '';
if (isset($params['note']))
{
	$note = ($params['note']);
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'incidents');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$note = '';
if (isset($params['note']))
{
	$note = $params['note'];
	if ($note != '')
	{
		$note_id = $db->GenID(cms_db_prefix()."module_servicedesk_notes_seq");
		$user_id = get_userid();
		$note_date = trim($db->DBTimeStamp(time()), "'");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_notes (note_id, incident_id, user_id, note, note_date)
			VALUES (?,?,?,?,?)';
		$db->Execute($query, array($note_id, $incident_id, $user_id, $note, $note_date));
		$params = array('tab_message'=> 'noteadded', 'active_tab' => 'incidents');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		echo $this->ShowErrors($this->Lang('nonotegiven'));
	}
}


#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'addincidentnote', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('notetext', $this->Lang('note'));
$this->smarty->assign('noteinput', $this->CreateTextArea(false, $id, $note,'note'));

$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'incident_id', $incident_id));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editincidentnote.tpl');
?>