<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports adding incidents
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
 
$db = cmsms()->GetDb();

if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use ServiceDesk')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'incidents');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}
$servicedeskversion = $this->GetPreference('servicedeskversion');

$product = '';
if (isset($params['product']))
{
	$product = $params['product'];
}

$usedcategory = 0;
if (isset($params['cat_id']))
{
	$usedcategory = $params['cat_id'];
}

$usedrequestor = 0;
if (isset($params['requestor_id']))
{
	$usedrequestor = $params['requestor_id'];
}

$usedstatus = $this->GetPreference('defaultstatus', 'OP');
if (isset($params['status']))
{
	$usedstatus = $params['status'];
}

$sendmail = 0;
if (isset($params['sendmail']))
{
	$sendmail = $params['sendmail'];
}

$requestor_ref = '';
if (isset($params['requestor_ref']))
{
	$requestor_ref = $params['requestor_ref'];
}

$detail_description = '';
if (isset($params['detail_description']))
{
	$detail_description = $params['detail_description'];
}

$usedowner_id = $this->GetPreference('defaultowner', 0);
if (isset($params['owner_id']))
{
	$usedowner_id = $params['owner_id'];
}

$usedpriority = '5';
if (isset($params['priority']))
{
	$usedpriority = $params['priority'];
}

$usedpriorityseq = 5;
if (isset($params['priorityseq']))
{
	$usedpriorityseq = $params['priorityseq'];
}

$description = '';
$errmessage = '';
if (isset($params['description']) )
{
	$description = $params['description'];
	if ($description != '')
	{
		$incident_id = $db->GenID(cms_db_prefix()."module_servicedesk_incidents_seq");
		$now = trim($db->DBTimeStamp(time()), "'");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incidents (incident_id, 
			description, product, cat_id, requestor_id, status, sendmail, 
			requestor_ref, detail_description, owner_id, priority, priorityseq, create_date,
			modified_date, start_date, end_date)
			VALUES (?,?,?,?,?,?,?,
				?,?,?,?,?,?,
				?,?,?)';
		$db->Execute($query, array($incident_id, $description, $product, $usedcategory, 
			$usedrequestor, $usedstatus, $sendmail, $requestor_ref, $detail_description, 
			$usedowner_id, $usedpriority, $usedpriorityseq,
			$now, NULL, $now, NULL));

		if ($usedstatus == 'CL') {
			// Status set to closed, set the end date
			$this->CloseIncident($incident_id);
		}

		if ($servicedeskversion == 'gold') {
			// Insert the attributes for this incident
			// First remove the existing attributes of the incident
			$query = 'DELETE FROM '.cms_db_prefix().'module_servicedesk_incident_attributes 
				WHERE incident_id = ?';
			$db->Execute($query, array((int)$params['incident_id']));
			// Use only filled fields
			foreach ( $params as $key => $value ) {
				if( !preg_match('/fld_/', $key ) )
				{
					continue;
				}
				$value = trim($value);
				
				// Adjust the key to get the field name
				$fldname = substr($key,4);
				if( !isset($params['info_'.$fldname]) )
				{
					// Something went wrong, trigger error
					continue;
				}
				list($fldtype,$fldid) = explode(',',trim($params['info_'.$fldname]));
				$pass = true;
				switch( $fldtype )
					{
					case 'image':
						{
							$res = true;
							if( isset( $params['del_'.$fldname] ) ) {
								$res = sdattr_utils::IncidentImageDelete($id, $incident_id, $value);
								// Now that image has been deleted, bail out otherwise image will be loaded again
								$value = '';
								break;
							}
							if( !$res )	{
								$pass = false;
								$errors[] = $this->Lang('error_filedelete');
							}
							else {
								$t_value = '';
								$t_result = '';
								$res = sdattr_utils::IncidentImageUpload($id, $key, $incident_id,
									$t_value,$t_result);
								if( !$res && !empty($result))
								{
									$pass = false;
									$errors[] = $t_result;
								}
								if( $res && !empty($t_value) )
								{
									$value = $t_value;
								}
							}
						}
						break;
					
					case 'file':
						{
							$res = true;
							if( isset( $params['del_'.$fldname] ) ) {
								$res = sdattr_utils::IncidentFileDelete($id, $incident_id, $value);
								// Now that file has been deleted, bail out otherwise file will be loaded again
								$value = '';
								break;
							}
							
							if( !$res ) {
								$pass = false;
								$errors[] = $this->Lang('error_filedelete');
							}
							else {
								$t_value = '';
								$t_result = '';
								$res = sdattr_utils::IncidentFileUpload($id, $key, $incident_id,
									$value,$result);
								if( !$res && !empty($result))
								{
									$pass = false;
									$errors[] = $result;
								}
								if( $res && !empty($t_value) )
								{
									$value = $t_value;
								}
							}
						}
						break;
					}
				
				// Save the found value
				if( $pass && !empty($value))
				{
					$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incident_attributes
					 (incident_id, attr_id, value)
						VALUES (?,?,?)';
					$dbr = $db->Execute( $query, array( $incident_id, $fldid, $value) );
				}	
			}
		}

		// All things saved, check if mail to requestor is to be send
		if ($sendmail == 1) {
		}
		// Check if mail to incident owner is to be send
		if ($this->GetPreference('sendmailincident2admin')) {
			sdbe_utils::SendMailIncident2Admin($incident_id);
		}

		$params = array('tab_message'=> 'incidentadded', 'active_tab' => 'incidents');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		$errmessage = $this->Lang('noincidentdescgiven');
		echo $this->ShowErrors($errmessage);
	}
}
if ($servicedeskversion == 'gold') {
	// Add attributes to the form
	$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_attributes';
	$attributedefs = $db->GetArray($query);
	if( isset($params['incident_id']) ) {
		// Connect any available values of the attributes
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incident_attributes
			WHERE incident_id = ?';
		$attributevals = $db->GetArray($query,array((int)$params['incident_id']));
		if( $attributevals ) {
			$tmp = sdattr_utils::MergeByKeys($attributedefs,$attributevals,'attr_id','attr_id');
			$attributedefs = $tmp;
		}
	}
	
	$attributes = array();
	foreach( $attributedefs as $oneattribute )
	{
		if( !isset($oneattribute['value']) ) $oneattribute['value'] = '';
		
		$oneattribute['hidden'] = $this->CreateInputHidden($id,'info_'.$oneattribute['name'],
				 $oneattribute['type'].','.$oneattribute['attr_id']);
	 
		switch( $oneattribute['type'] ) {
			case 'textbox':
				$size = min(50,$oneattribute['max_length']);
				$oneattribute['field'] = $this->CreateInputText($id,'fld_'.$oneattribute['name'],
					$oneattribute['value'],$size,$oneattribute['max_length']);
				break;
			case 'textarea':
				$oneattribute['field'] = $this->CreateTextArea(true,$id,$oneattribute['value'],'fld_'.
					$oneattribute['name']);
				break;
			case 'checkbox':
				$oneattribute['field'] = $this->CreateInputCheckbox($id,'fld_'.$oneattribute['name'],
					1,$oneattribute['value']);
				break;
			case 'dropdown':
				{
					$tmp = explode("\n",$oneattribute['options']);
					$tmp2 = array();
					foreach( $tmp as $one )
					{
						$one = trim($one);
						$tmp2[$one] = $one;
					}
					$oneattribute['field'] = $this->CreateInputDropdown($id,'fld_'.$oneattribute['name'],
						$tmp2,-1,$oneattribute['value']);
				}
				break;
			case 'image':
				if( !empty($oneattribute['value']) ) {
					$oneattribute['display_value'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$oneattribute['value'];
					$oneattribute['delete_attribute'] = $this->CreateInputCheckbox($id,'del_'.
						$oneattribute['name'],1,0);
				}
				$oneattribute['field'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
					$oneattribute['value']).$this->CreateFileUploadInput($id,'fld_'.$oneattribute['name'],
						'',30);
				break;
			case 'file':
				if( !empty($oneattribute['value']) ) {
					$oneattribute['display_value'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$oneattribute['value'];
					$oneattribute['delete_attribute'] = $this->CreateInputCheckbox($id,'del_'.$oneattribute['name'],1,0);
				}
				$oneattribute['field'] = $this->CreateInputHidden($id,'fld_'.$oneattribute['name'],
						$oneattribute['value']).$this->CreateFileUploadInput($id,'fld_'.$oneattribute['name'],'',30);
				break;
		}
		$attributes[] = $oneattribute;
	}
	if( count($attributes) ) {
	  $smarty->assign('attributes',$attributes);
	  $smarty->assign('countattributes', count($attributes));
	
	}
}

// Prepare a list of categories
$categorylist = array();
$categorylist = $this->GetListCategories();

// Prepare a list of requestors
$requestorlist = array();
$requestorlist = $this->GetListRequestors($this->Lang('newrequestor'));
$gid = (int)$this->GetPreference('customer_group');
if ($gid == -1) {
	echo $this->ShowErrors($this->Lang('error_customer_group_unknown'));
}
else {
	$smarty->assign('memberof',$gid);
}

// Prepare a list of statusses
$statuslist = array();
$statuslist = $this->GetListStatusses();

// Prepare a list of internal users (one of which will be the owner)
$ownerlist = array();
$ownerlist = sdbe_utils::GetListOwners();

// Prepare the various priorities
$prioritydropdown = array();
$prioritydropdown = $this->GetListPriorities();

// Prepare the various priorities scores
$priorityseqdropdown = array();
$priorityseqdropdown = $this->GetListPrioritySeq();

// Make sure there is no index warning when running in debug mode
$smarty->assign('incident_id', -1);

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addincident', $returnid, 'post', 'multipart/form-data'));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
$smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 80, 80, 'class="defaultfocus"'));
$smarty->assign('producttext', $this->Lang('product'));
$smarty->assign('productinput', $this->CreateInputText($id, 'product', $product, 20, 20));
$smarty->assign('categorytext', $this->Lang('category'));
$smarty->assign('categoryinput', $this->CreateInputDropdown($id, 'cat_id', $categorylist, -1, $usedcategory));
$smarty->assign('requestortext', $this->Lang('requestor'));
$smarty->assign('requestorinput', $this->CreateInputDropdown($id, 'requestor_id', $requestorlist, -1, $usedrequestor));
$smarty->assign('title_adduseraccount', $this->Lang('title_adduseraccount'));
$smarty->assign('requestor_reftext', $this->Lang('requestor_reference'));
$smarty->assign('requestor_refinput', $this->CreateInputText($id, 'requestor_ref', $requestor_ref, 25, 25));
$smarty->assign('detaildesctext', $this->Lang('detaildescription'));
$smarty->assign('detaildescinput', $this->CreateTextArea($this->GetPreference('enableeditor', true),
	$id, $detail_description, 'detail_description', '', '', '', '', '80', '3'));
$smarty->assign('prioritytext', $this->Lang('priority'));
$smarty->assign('priorityinput', $this->CreateInputDropdown($id, 'priority', $prioritydropdown, -1, $usedpriority));
$smarty->assign('priorityseqtext', $this->Lang('priorityseq'));
$smarty->assign('priorityseqinput', $this->CreateInputDropdown($id, 'priorityseq', $priorityseqdropdown, -1, $usedpriorityseq));
$smarty->assign('statustext', $this->Lang('status'));
$smarty->assign('statusinput', $this->CreateInputDropdown($id, 'status', $statuslist, -1, $usedstatus));
$smarty->assign('sendmailtext',$this->Lang('sendmailincident'));
$smarty->assign('sendmailinput', $this->CreateInputCheckbox($id, 'sendmail', true, $this->GetPreference('sendmailincident', true)));
$smarty->assign('ownertext', $this->Lang('owner'));
$smarty->assign('ownerinput', $this->CreateInputDropdown($id, 'owner_id', $ownerlist, -1, $usedowner_id));
$smarty->assign('title_attributes', $this->Lang('title_attributes'));

$smarty->assign('hidden', '');
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editincident.tpl');
?>