<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports adding categories
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$db = cmsms()->GetDb();

if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use ServiceDesk')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'categories');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$code = '';
$description = '';
$errmessage = '';
if (isset($params['code']) || isset($params['description']) )
{
	$code = $params['code'];
	$description = $params['description'];
	if ($code != '' && $description != '')
	{
		$cat_id = $db->GenID(cms_db_prefix()."module_servicedesk_categories_seq");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_categories (cat_id, code, description)
			VALUES (?,?,?)';
		$db->Execute($query, array($cat_id, $code, $description));

		$params = array('tab_message'=> 'categoryadded', 'active_tab' => 'categories');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		if ($code == '') $errmessage = $this->Lang('nocatcodegiven');
		if ($description == '') {
			if ($errmessage != '') $errmessage .= '<br />';
			$errmessage .= $this->Lang('nocatdescgiven');
		}
		echo $this->ShowErrors($errmessage);
	}
}


#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'addcategory', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('codetext', '*'.$this->Lang('categorycode'));
$this->smarty->assign('codeinput', $this->CreateInputText($id, 'code', $code, 10, 10, 'class="defaultfocus"'));
$this->smarty->assign('descriptiontext', $this->Lang('categorydescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 40, 80));
$this->smarty->assign('hidden', '');
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editcategory.tpl');
?>