<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010-2012 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is http://dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2012 by Ted Kulp
#          The projects homepage is: http://www.cmsmadesimple.org
# Version: 0.9.4
# File   : class.advanced_content.php
# Purpose: the content object
# License: GPL
#
#-------------------------------------------------------------------------------
/**
 * @package AdvancedContent
 * @category CMSModuleContentType
 * @license GPL
 * @author Georg Busch (NaN)
 * @copyright 2010-2012 Georg Busch (NaN)
 * @since 0.9.4
 */
class advanced_content extends CMSModuleContentType
{
	private $_stylesheet;
	private $_loaded;
	private $_feuAction;
	private $_feuAccess;
	private $_feuGroups;
	private $_inheritables;
	private $_advancedAttribs = array(
		'use_expire_date',
		'start_date',
		'end_date',
		'feu_access',
		'redirect_page',
		'feu_action',
		'hide_menu_item',
		'inherit_redirect_params',
		'feu_params',
		'inherit_feu_params',
		'feu_params_smarty',
		'custom_params',
		'inherit_custom_params',
		'custom_params_smarty'
	);
	
	function __construct()
	{
		parent::__construct();
		$this->_loaded    = false;
		$this->_feuAction = false;
		$this->_feuAccess = -1;
		$this->_feuGroups = false;
	}
	
	function SetProperties()
	{
		parent::SetProperties();
		$this->AddBaseProperty('template', 4, 0, 'int');
		$this->AddBaseProperty('pagemetadata', 20);
		
		$this->AddContentProperty('searchable', 8, 0, 'int');
		$this->AddContentProperty('pagedata', 25);
		$this->AddContentProperty('disable_wysiwyg', 60, 0, 'int');
		
		if(ac_utils::get_module('AdvancedContent')->GetPreference('use_advanced_pageoptions', 0))
		{
			$this->AddContentProperty('use_expire_date', 99, 0, 'int');
			$this->AddContentProperty('start_date', 100, 0, 'int');
			$this->AddContentProperty('end_date', 101, 0, 'int');
			
			if($feusers =& ac_utils::get_module('FrontEndUsers'))
			{
				$this->AddContentProperty('feu_access', 102);
				$this->AddContentProperty('redirect_page', 103, 0, 'int');
				
				$this->AddContentProperty('inherit_feu_params', 104, 0,'int');
				$this->AddContentProperty('feu_params', 105, 0);
				$this->AddContentProperty('feu_params_smarty', 106, 0, 'int');
				
				$this->AddContentProperty('inherit_custom_params', 107, 0,'int');
				$this->AddContentProperty('custom_params', 108, 0);
				$this->AddContentProperty('custom_params_smarty', 109, 0, 'int');
				
				$this->AddContentProperty('feu_action', 110, 0, 'int');
				$this->AddContentProperty('hide_menu_item', 111, 0, 'int');
			}
		}
		
		# Backward compatibility (deprecated)
		$this->mPreview = true; # ToDo: remove this
	}
	
	function FriendlyName()
	{
		return ac_admin_ops::FriendlyName($this);
	}
	
	function ModuleName()
	{
		return 'AdvancedContent';
	}
	
	function IsDefaultPossible()
	{
		return TRUE;
	}
	
	function IsCopyable()
	{
		return TRUE;
	}
	
	function HasPreview()
	{
		return true;
	}
	
	function ShowInMenu()
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		if($AC->GetPreference('use_advanced_pageoptions', 0))
		{
			if($this->GetProperty('use_expire_date'))
			{
				$start_date = $this->GetProperty('start_date');
				$end_date   = $this->GetProperty('end_date');
				if(($start_date > time() || $end_date < time()) && $this->Active())
				{
					$this->SetActive(false);
					$this->SetShowInMenu(false);
				}
				else if($start_date < time() && $end_date > time() && !$this->Active())
					$this->SetActive(true);
			}
			if(ac_utils::cms_access() == 'frontend' && $feusers =& ac_utils::get_module('FrontEndUsers'))
			{
				if($this->GetProperty('hide_menu_item'))
				{
					if($this->GetProperty('hide_menu_item') == 1)
						$this->SetShowInMenu($this->_check_frontend_page_access());
					else if($this->GetProperty('hide_menu_item') == 2)
						$this->SetShowInMenu(!$feusers->LoggedIn());
				}
			}
		}
		return parent::ShowInMenu();
	}
	
	function Active()
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		if($AC->GetPreference('use_advanced_pageoptions', 0))
		{
			if($this->GetProperty('use_expire_date'))
			{
				$start_date = $this->GetProperty('start_date');
				$end_date   = $this->GetProperty('end_date');
				if(($start_date > time() || $end_date < time()) && parent::Active())
				{
					$this->SetActive(false);
					$this->SetShowInMenu(false);
				}
				else if($start_date < time() && $end_date > time() && !parent::Active())
					$this->SetActive(true);
			}
		}
		return parent::Active();
	}
	
	function Cachable()
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		if($AC->GetPreference('use_advanced_pageoptions', 0) 
			&& ac_utils::cms_access() == 'frontend' 
			&& $feusers =& ac_utils::get_module('FrontEndUsers')
			&& $this->GetProperty('feu_access'))
		{
			$this->SetCachable(false);
		}
	}
	
	function ReadyForEdit() {/*???*/}
	
	function Show($param = 'content_en')
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		
		# check page access
		if($AC->GetPreference('use_advanced_pageoptions', 0) 
			&& ac_utils::cms_access() == 'frontend' 
			&& !$this->_check_frontend_page_access())
		{
			if($param == 'content_en') # fix by Jonathan Schmid (aka Foaly*)
			{
				return $this->_do_feu_action();
			}
			return;
		}
		
		$param = preg_replace('/-+/', '_', munge_string_to_url($param));
		$this->_loaded = false;
		
		# should never happen since CMSms 1.11
		if(!$contentBlock = &$this->GetContentBlock($param))
		{
			$config = cmsms()->GetConfig();
			if($config['debug'])
				trigger_error("AdvancedContent: The content block '" . $param . "' does not exist!", E_USER_WARNING);
			return;
		}
		
		# todo: check if this is a good idea to process smarty in params when in frontend
		if($contentBlock->GetProperty('smarty'))
		{
			foreach($contentBlock->GetProperties() as $propName=>$propValue)
				$contentBlock->SetProperty($propName, ac_utils::DoSmarty($this, $propValue));
		}
		
		# check block access
		if($feusers = &ac_utils::get_module('FrontEndUsers'))
		{
			if($contentBlock->GetProperty('feu_access') && !$this->_is_member_of($contentBlock->GetProperty('feu_access')))
			{
				if($contentBlock->GetProperty('feu_action') && !$this->_feuAction)
				{
					$this->_feuAction = true;
					$this->SetPropertyValueNoLoad($param, $feusers->DoAction('default', 'cntnt01', array('form'=>'login'), $this->Id()));
				}
				else
					$this->SetPropertyValueNoLoad($param,'');
			}
			else if($contentBlock->GetProperty('feu_hide') && $feusers->LoggedInId())
				$this->SetPropertyValueNoLoad($param, '');
		}
		
		# set block specific output
		$this->SetPropertyValueNoLoad($param, $contentBlock->Show());
		
		# set default value (if neccessary)
		if(!$contentBlock->GetProperty('allow_none') && $this->GetPropertyValue($param) == '')
			$this->SetPropertyValueNoLoad($param, $contentBlock->GetProperty('default'));
		
		return $this->GetPropertyValue($param);
	}
	
	function TabNames()
	{
		$this->GetContentBlocks();
		return acTabManager::GetTabNames();
	}
	
	function FillParams($params, $editing = false)
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		$parameters = array_merge(array('pagedata', 'searchable', 'disable_wysiwyg'), $this->_advancedAttribs);
		$this->_loaded = false;
		if(isset($params['parent_id']) && $params['parent_id'] != $this->ParentId())
			$this->SetItemOrder(-1);
		$this->SetTemplateId(isset($params['template_id']) ? $params['template_id'] : $this->TemplateId());
		$this->SetParentId(isset($params['parent_id'])     ? $params['parent_id']   : $this->ParentId());
		$this->GetContentBlocks();
		ac_admin_ops::FillParams($this, $params, $editing);
		parent::FillParams($params, $editing);
	}
	
	function EditAsArray($adding = false, $tab = 0, $showadmin = false)
	{
		$this->GetContentBlocks();
		return ac_admin_ops::EditAsArray($this, $adding, $tab, $showadmin);
	}
	
	function ValidateData()
	{
		return ac_admin_ops::ValidateData($this, parent::ValidateData());
	}
	
	function display_single_element($one, $adding)
	{
		if(in_array($one, $this->_advancedAttribs))
			return;
		if(!$ret = ac_admin_ops::DisplayAttributes($this, $one, $adding))
			$ret = parent::display_single_element($one, $adding);
		return $ret;
	}


/**
 * -----------------------------------------------------------------------------
 * Custom functions
 * -----------------------------------------------------------------------------
 */

	public function DisplayAttributes($adding, $tab)
	{
		return parent::display_attributes($adding, $tab);
	}
	
	public function GetStylesheet()
	{
		return $this->_stylesheet;
	}
	
	public function GetProperty($propName)
	{
		$propValue = $this->GetPropertyValue($propName);
		if(ac_utils::get_module('AdvancedContent')->GetPreference('use_advanced_pageoptions', 0))
		{
			if(!$this->_inheritables)
				$this->_inheritables =& ac_utils::GetInheritables($this->Id());
			
			if(!isset($this->_inheritables[$propName]))
				return $propValue;
			
			$inherit = false;
			if($propName == 'feu_access')
			{
				$delim     = strpos($propValue,',') === FALSE ? ';' : ',';
				$propValue = ac_utils::CleanArray(explode($delim,$propValue));
				if(in_array(-1,$propValue))
					$inherit = true;
			}
			else if($propValue == -1)
				$inherit = true;
			
			if($inherit)
				$propValue = $this->InheritParentProp($propName,$propValue);
			
			if($propName == 'feu_params' || $propName == 'custom_params')
			{
				$matches = array();
				$result  = preg_match_all(AC_BLOCK_PARAM_PATTERN, $propValue, $matches);
				$params1 = array();
				$params2 = array();
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					if(startswith($matches[2][$i],'\''))
						$matches[2][$i] = trim($matches[2][$i],'\'');
					else if(startswith($matches[2][$i],'"'))
						$matches[2][$i] = trim($matches[2][$i],'"');
					
					$params1[$matches[1][$i]] = $matches[2][$i];
					$params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
				}
				$propValue = array($params1,$params2);
			}
		}
		return $propValue;
	}
	
	public function &GetContentBlocks()
	{
		$AC = &ac_utils::get_module('AdvancedContent');
		if(ac_utils::cms_access() == 'frontend' && $AC->GetPreference('use_advanced_pageoptions', 0) && !$this->_check_frontend_page_access())
			return;
		
		$this->_stylesheet = '../stylesheet.php?templateid='.$this->TemplateId();
		$parse_template    = !$this->_loaded;
		$this->_loaded     = true;
		
		return acContentBlockManager::GetContentBlocks($this, $parse_template);
	}
	
	public function &GetContentBlock($block_id)
	{
		return acContentBlockManager::GetContentBlock($this, $block_id, !$this->_loaded);
	}
	
	public function InheritParentProp($propName, $currentProp = array())
	{
		return ac_utils::InheritParentProp($this->Id(), $this->ParentId(), $propName, $currentProp);
	}
	
	/**
	 * Checks if a frontend user is logged in and belongs to a certain group
	 * @param array|string $feu_groups - the allowed frontend user groups the user should belong to (array or csv)
	 * @return bool
	 */
	private function _is_member_of($feu_groups)
	{
		$access = true;
		if(!is_array($feu_groups))
			$feu_groups = ac_utils::CleanArray(explode(',',$feu_groups));
		
		if( $feusers =& ac_utils::get_module('FrontEndUsers') && !empty($feu_groups))
		{
			$access = false;
			$userid = $feusers->LoggedInId();
			if($userid && $groups =& $this->_get_feu_groups($userid))
			{
				foreach($groups as $onegroup)
				{
					#if(in_array($onegroup['groupid'],$feu_groups) || in_array($onegroup['groupname'],$feu_groups))
					if(in_array($onegroup['groupid'],$feu_groups))
					{
						$access = true;
						break;
					}
				}
			}
		}
		return $access;
	}
	
	
	/**
	 * Just gets all frontend user groups a frontend user belongs to
	 * and caches them in a member variable
	 * @param int $userid - the id of the user
	 * @return array
	 */
	private function &_get_feu_groups($userid)
	{
		if(!$userid)
			return false;
		if( $feusers =& ac_utils::get_module('FrontEndUsers') && !$this->_feuGroups)
			$this->_feuGroups = $feusers->GetMemberGroupsArray($userid);
		return $this->_feuGroups;
	}
	
	
	/**
	 * Checks if a frontend user has access to a page
	 * @return boolean
	 */
	private function _check_frontend_page_access()
	{
		if($this->_feuAccess == -1 && $feu =& ac_utils::get_module('FrontEndUsers'))
			$this->_feuAccess = ($this->GetProperty('hide_menu_item') == 2 && $feu->LoggedInId()) ? false : $this->_is_member_of($this->GetProperty('feu_access'));
		return $this->_feuAccess;
	}
	
	
	/**
	 * Perform the selected action if a page is accessed where the user has no access
	 */
	private function _do_feu_action()
	{
		if( $feusers =& ac_utils::get_module('FrontEndUsers' ))
		{
			$AC = &ac_utils::get_module('AdvancedContent');
			
			$redirectPage = $this->GetProperty('redirect_page');
			if($redirectPage == $this->Id() || $redirectPage == $this->Alias())
				$redirectPage = '';
			
			# get feu_params
			if(!$this->GetPropertyValue('inherit_feu_params'))
			{
				$feu_params        = $this->GetPropertyValue('feu_params');
				$feu_params_smarty = $this->GetPropertyValue('feu_params_smarty');
			}
			else
			{
				$feu_params        = $this->InheritParentProp('feu_params');
				$feu_params_smarty = $this->InheritParentProp('feu_params_smarty');
			}
			if($feu_params_smarty)
				#$feu_params = $feusers->ProcessTemplateFromData($feu_params);
				$feu_params = $AC->smarty->fetch('string:' . $feu_params);
			
			$matches = array();
			$result  = preg_match_all(AC_BLOCK_PARAM_PATTERN, $feu_params, $matches);
			$feu_params1 = array(); # array(param_name => param_value)
			$feu_params2 = array(); # string "param_name=param_value"
			for ($i = 0; $i < count($matches[1]); $i++)
			{
				if(startswith($matches[2][$i],'\''))
					$matches[2][$i] = trim($matches[2][$i],'\'');
				else if(startswith($matches[2][$i],'"'))
					$matches[2][$i] = trim($matches[2][$i],'"');
				
				$feu_params1[$matches[1][$i]] = $matches[2][$i];
				$feu_params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
			}
			#---
			
			# do feu_action
			$feuAction = $this->GetProperty('feu_action');
			if(!$redirectPage)
			{
				if($feuAction && !$this->_feuAction)
				{
					$this->_feuAction = true;
					# cannot pass custom_params when DoAction() is used
					return $feusers->DoAction('default', 'cntnt01', array_merge(array('form'=>'login'),$feu_params1), $this->Id());
				}
				return;
			}
			
			# get custom_params
			if(!$this->GetPropertyValue('inherit_custom_params'))
			{
				$custom_params        = $this->GetPropertyValue('custom_params');
				$custom_params_smarty = $this->GetPropertyValue('custom_params_smarty');
			}
			else
			{
				$custom_params        = $this->InheritParentProp('custom_params');
				$custom_params_smarty = $this->InheritParentProp('custom_params_smarty');
			}
			if($custom_params_smarty)
				#$custom_params = $feusers->ProcessTemplateFromData($custom_params);
				$custom_params = $AC->smarty->fetch('string:' . $custom_params);
			
			$matches = array();
			$result  = preg_match_all(AC_BLOCK_PARAM_PATTERN, $custom_params, $matches);
			$custom_params1 = array();
			$custom_params2 = array();
			for ($i = 0; $i < count($matches[1]); $i++)
			{
				if(startswith($matches[2][$i],'\''))
					$matches[2][$i] = trim($matches[2][$i],'\'');
				else if(startswith($matches[2][$i],'"'))
					$matches[2][$i] = trim($matches[2][$i],'"');
				
				$custom_params1[$matches[1][$i]] = $matches[2][$i];
				$custom_params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
			}
			
			if($feuAction)
			{
				$url = $feusers->CreateFrontendLink('cntnt01', $redirectPage, 'default', '', $feu_params1, '', true, false, true) . (!empty($custom_params2) ? '&' . implode('&',$custom_params2) : ''); 
				#return $feusers->RedirectForFrontEnd('cntnt01', $redirectPage, 'default', $feu_params1, false);
			}
			else
			{
				$manager =& cmsms()->GetHierarchyManager();
				$node    = $manager->sureGetNodeByAlias($redirectPage);
				if(!is_object($node))
					return;
				$content =& $node->GetContent();
				if (!is_object($content) || !$url = $content->GetURL())
					return;
				
				if(!empty($custom_params1) && !empty($custom_params2))
				{
					$config = cmsms()->GetConfig();
					$url = trim(
						str_replace(
							array(
								$config['root_url'] . '/index.php',
								$config['ssl_url'] . '/index.php',
								$config['root_url'],
								$config['ssl_url']
							),
							'', 
							$url
						),
						'/?'
					);
					
					if($config['url_rewriting'] == 'none')
					{
						if($content->Secure())
							$url = $config['ssl_url'] . '/index.php?' . implode('&',$custom_params2) . '&' . $url;
						else
							$url = $config['root_url'] . '/index.php?' . implode('&',$custom_params2) . '&' . $url;
					}
					else if($config['url_rewriting'] == 'internal')
					{
						if($content->Secure())
							$url = $config['ssl_url'] . '/index.php/' . implode('/',$custom_params1) . '/' . $url;
						else
							$url = $config['root_url'] . '/index.php/' . implode('/',$custom_params1) . '/' . $url;
						
						if($content->DefaultContent())
							$url .= $content->Alias() . $config['page_extension'];
					}
					else if($config['url_rewriting'] == 'mod_rewrite')
					{
						if($content->Secure())
							$url = $config['ssl_url'] . '/' . implode('/',$custom_params1) . '/' . $url;
						else
							$url = $config['root_url'] . '/' . implode('/',$custom_params1) . '/' . $url;
						
						if($content->DefaultContent())
							$url .= $content->Alias() . $config['page_extension'];
					}
				}
			}
			return redirect($url);
		}
	}
	
	
	/**
	 * Just a wrapper to get a module instance in the template
	 *
	 * @param string $module_name - the exact name of the module (case sensitive)
	 * @param string $module_version (optional) - the minimum version of the module
	 * @return object
	 */
	public function &get_module($module_name,$module_version = '') 
	{
		return ac_utils::get_module($module_name, $module_version);
	}
	
	public function IsKnownProperty($name)
	{
		return $this->is_known_property($name);
	}
	
	public function GetAdvancedAttribs()
	{
		return $this->_advancedAttribs;
	}


/**
 * -----------------------------------------------------------------------------
 * backward compatibility (deprecated stuff)
 * -----------------------------------------------------------------------------
 */

	public function AddExtraProperty($name, $type = 'string')
	{
		if(method_exists(get_parent_class('advanced_content'), 'AddExtraProperty'))
			parent::AddExtraProperty($name, $type);
	}
	
	public function SetPropertyValueNoLoad($propname, $propvalue)
	{
		if(method_exists(get_parent_class('advanced_content'), 'SetPropertyValueNoLoad'))
			return parent::SetPropertyValueNoLoad($propname, $propvalue);
		return parent::SetPropertyValue($propname, $propvalue);
	}
	
	public function __call($name, $arguments)
	{
		$args = '';
		foreach($arguments as $i => $arg)
		{
			$args .= '$arguments[$i],';
		}
		$args .= '\'dummy\'';
		
		$config = cmsms()->GetConfig();
		if($config['debug'])
			trigger_error('AdvancedContent method "' . $name . '()" is deprecated!', E_USER_WARNING);
		
		if(method_exists('acContentBlockManager', $name))
			return eval('return acContentBlockManager::' . $name . '('.$args.');');
		switch($name)
		{
			case 'get_content_blocks':
				return $this->GetContentBlocks();
		}
	}
}

?>
