<?php
/**
 * Class definition and methods for AdvancedContent contentblock types.<br />
 * All block types needs to inherit and extend this class!
 *
 * @package AdvancedContent
 * @category CMSModuleContentType
 * @license GPL
 * @author Georg Busch (NaN)
 * @copyright 2010-2012 Georg Busch (NaN)
 * @since 0.9
 * @abstract
 * @access public
 */
abstract class acContentBlockBase
{
	/**
	 * @ignore
	 */
	private $_properties = array('active' => true); // we shouldn't be here if the block is not active
	
	/**
	 * @ignore
	 */
	private $_content = NULL;
	
	/**
	 * @ignore
	 */
	protected $content_obj;
	
	/**
	 * @ignore
	 */
	protected $_header_html_called = false;
	
	/**
	 * Constructor.<br />
     * Required for all subclasses.<br />
     * Should be called from each subclass as the very first.
     * @param array $params - the parameters of that contentblock
     */
	function __construct(&$content_obj, $params = array())
	{
		$this->content_obj = $content_obj;
		
		$AC = &ac_utils::get_module('AdvancedContent');
		
		$this->_properties['smarty']           = isset($params['smarty'])        ? $params['smarty']        : false;
		$this->_properties['editor_groups']    = isset($params['editor_groups']) ? $params['editor_groups'] : '';
		$this->_properties['editor_users']     = isset($params['editor_users'])  ? $params['editor_users']  : '';
		$this->_properties['type']             = isset($params['block_type'])    ? $params['block_type']    : '';
		$this->_properties['name']             = isset($params['block'])         ? $params['block']         : 'content_en';
		$this->_properties['id']               = isset($params['block_id'])      ? $params['block_id']      : preg_replace('/-+/','_', munge_string_to_url($this->_properties['name']));
		$this->_properties['label']            = isset($params['label'])         ? $params['label']         : ucwords($this->_properties['name']);
		$this->_properties['default']          = isset($params['default'])       ? $params['default']       : '';
		$this->_properties['style']            = isset($params['style'])         ? $params['style']         : ''; # deprecated
		$this->_properties['page_tab']         = isset($params['page_tab'])      ? $params['page_tab']      : 'main';
		$this->_properties['block_tab']        = isset($params['block_tab'])     ? $params['block_tab']     : '';
		$this->_properties['block_group']      = isset($params['block_group'])   ? $params['block_group']   : '';
		$this->_properties['description']      = isset($params['description'])   ? $params['description']   : '';
		
		$this->_properties['translate_labels'] = (isset($params['translate_labels']) && ac_utils::IsTrue($params['translate_labels']));
		$this->_properties['translate_values'] = (isset($params['translate_values']) && ac_utils::IsTrue($params['translate_values']));
		$this->_properties['required']         = (isset($params['required'])         && ac_utils::IsTrue($params['required']));
		$this->_properties['allow_none']       = !(isset($params['allow_none'])      && ac_utils::IsFalse($params['allow_none']));
		$this->_properties['no_collapse']      = (isset($params['no_collapse'])      && ac_utils::IsTrue($params['no_collapse']));
		$this->_properties['collapsible']      = !$this->_properties['no_collapse']  && $this->_properties['type'];
		
		if(!$this->_properties['collapsible'])
			$this->_properties['collapse'] = false;
		else
			$this->_properties['collapse'] = isset($params['collapse']) ? !ac_utils::IsFalse($params['collapse']) : $AC->GetPreference('collapse_block_default', true);
		
		$this->_properties['feu_access'] = isset($params['feu_access']) ? $params['feu_access'] : ''; 
		$this->_properties['feu_action'] = (isset($params['feu_action']) && ac_utils::IsTrue($params['feu_action']));
		$this->_properties['feu_hide']   = (isset($params['feu_hide']) && ac_utils::IsTrue($params['feu_hide']));
	}
	
	/**
	 * Backwards compatibility
	 * @ignore
	 * @internal
	 */
	public function __call($name, $arguments = array()) 
	{
		$_name = str_replace('Block', '', $name);
		$config = cmsms()->GetConfig();
		if($config['debug'])
			trigger_error('AdvancedContent blocktype method "' . $name . '()" is deprecated! Use "' . $_name . '()" instead.', E_USER_WARNING);
		if(method_exists($this, $_name))
			return $this->$_name(isset($arguments[0]) ? $arguments[0] : NULL, isset($arguments[1]) ? $arguments[1] : NULL, isset($arguments[2]) ? $arguments[2] : NULL);
		return false;
	}
	
	
	/**
	 * @ignore
	 * @internal
	 */
	public final function Type()
	{
		$class = get_class($this);
		if(strpos($class, "acBlockType_") === false)
			return AC_INVALID_BLOCK_TYPE;
		return substr($class, strlen("acBlockType_"));
	}
	
	/**
	 * Sets the value of a property. If not exists it will be created.
	 * @param string $name - the name of the property
	 * @param string $value - the value of the property
	 */
	public final function SetProperty($name, $value = '')
	{
		$this->_properties[strtolower($name)] = $value;
	}
	
	/**
	 * Returns the value of a property.
	 * @param string $name - the name of the property
	 * @param string $default - the default value of the property if not exists
	 * @return mixed - usually this will be a string
	 */
	public final function GetProperty($name, $default = '')
	{
		$name = strtolower($name);
		if(isset($this->_properties[$name]))
			return $this->_properties[$name];
		
		return $default;
	}
	
	/**
	 * Returns all valid properties of that block.
	 * @return array - array(propname => propvalue)
	 */
	public final function GetProperties()
	{
		return $this->_properties;
	}
	
	/**
	 * Defines additional properties of the blocktype that affects all blocks of this type 
	 * and needs to be stored "outside" the block.
	 * @return array - array(propname => propvalue)
	 * @abstract
	 */
	public function SetBlockTypeProperties() {}
	
	/**
	 * Gets the html output of the block in backend.<br />
	 * This method is required and needs to be overwritten.
	 * @return string
	 */
	public function GetInput() {}
	
	/**
	 * Gets the html that needs to be inserted in the head section for all blocks of this type when editing a page.<br />
	 * Can be useful to add css or js.<br/>
	 * Will be called only once for each block type.
	 * @return string
	 */
	public function GetHeaderHTML()
	{
		$this->_header_html_called = true;
	}
	
	/**
	 * Displays the help text for this blocktype.<br />
	 * Helptext will be displayed in modulehelp.
	 * @return string
	 */
	public function GetHelp()
	{
		return;
	}
	
	/**
	 * Displays the changelog text for this blocktype.<br />
	 * Changelog will be displayed in modules changelog.
	 * @return string
	 */
	public function GetChangeLog()
	{
		return;
	}
	
	/**
     * Function for the subclass to parse out data for it's parameters.<br />
     * Needs to be overwritten if the blocktype provides a special kind of data that needs to be processed before storing it.
     * @param array &$params - the parameters that are passed when the form is submitted
     * @param bool $editing - a flag to determine if the page is created or edited
     * @return string
     */
	public function FillParams(&$params, $editing = false)
	{
		return isset($params[$this->_properties['id']]) ? $params[$this->_properties['id']] : '';
	}
	
	/**
     * Function for the subclass to perform the blocks output<br />
     * Needs to be overwritten if the blocktype provides a special kind of data that needs to be processed before displaying it in frontend.
     * @return string
     */
	public function Show()
	{
		return $this->GetContent();
	}
	
	/**
     * Function for the subclass to validate its data
     * @return bool
     */
	public function Validate()
	{
		return $this->GetContent();
	}
	
	/**
     * Function to get the blocks raw content<br />
     * @return string
     * @since 0.9.4
     */
	public final function GetContent()
	{
		return $this->_content !== NULL ? $this->_content : $this->content_obj->GetPropertyValue($this->_properties['id']);
	}
	
	/**
     * Function to set the content of a block temporary on runtime to a certain value<br />
     * @return string
     * @since 0.9.4
     */
	protected final function SetContent($value)
	{
		$this->_content = $value;
	}
}
?>
