<?php
class acBlockType_image extends acContentBlockBase
{
	function __construct(&$content_obj, $params = array())
	{
		$params['block_type'] = 'image';
		parent::__construct($content_obj, $params);
		
		$config = cmsms()->GetConfig();
		
		$this->SetProperty('prefix', isset($params['prefix']) ? $params['prefix'] : 'thumb_');
		$this->SetProperty('exclude', !isset($params['exclude']) || ac_utils::IsFalse($params['exclude']));
		$this->SetProperty('dir', cms_join_path($config['uploads_path'], isset($params['dir']) ? $params['dir'] : get_site_preference('contentimage_path')));
		$this->SetProperty('inputname', isset($params['inputname']) ? $params['inputname'] : $this->GetProperty('id'));
	}
	
	public function GetInput()
	{
		$dropdown = create_file_dropdown(
			$this->GetProperty('inputname'),
			$this->GetProperty('dir'),
			$this->GetContent(),
			'jpg,jpeg,png,gif',
			'',
			$this->GetProperty('allow_none'),
			'',
			$this->GetProperty('prefix'),
			$this->GetProperty('exclude')
		);
		if( $dropdown === false )
			$dropdown = lang('error_retrieving_file_list');
		
		return $dropdown;
	}
}
?>
