// Requirements
var gulp = require('gulp'),
	 compass = require('gulp-compass'),
	 prefix = require('gulp-autoprefixer'),
	 compressor = require('gulp-compressor'),
	 concat = require('gulp-concat'),
	 run = require('gulp-run');

//
// Defines path to sass
//
var Theme = "Basic";
var Layout = "SingleCol";
var themesassRoot = 'themes/styling/' + Theme;
var layoutsassRoot = 'themes/layouts/' + Layout;

// Gulp task
gulp.task('theme-compass-to-css', function(){
	return gulp.src(themesassRoot+'/sass/Basic.scss')
			 .pipe(compass({
                config_file: themesassRoot + '/config.rb',
                css: themesassRoot + '/css',
                sass: themesassRoot + '/sass',
                require: 'sassy-buttons'
                }))
			 .pipe(prefix("last 3 versions"))
			 .pipe(gulp.dest(themesassRoot + '/css'))
});

gulp.task('layout-compass-to-css', function(){
	return gulp.src(layoutsassRoot+'/sass/base.scss')
			 .pipe(compass({
                config_file: layoutsassRoot + '/config.rb',
                css: layoutsassRoot + '/css',
                sass: layoutsassRoot + '/sass',
                require: 'susy'
                }))
			 .pipe(prefix("last 3 versions"))
			 .pipe(gulp.dest(layoutsassRoot + '/css'))
});

gulp.task('watch-compass', function(){
	// What to watch
	gulp.watch(themesassRoot + '/sass/Basic.scss', function(){
		// What to run
		gulp.run('theme-compass-to-css');
	});
	gulp.watch(layoutsassRoot + '/sass/Basic.scss', function(){
		// What to run
		gulp.run('layout-compass-to-css');
	});
});

gulp.task('all-compass', ['theme-compass-to-css', 'layout-compass-to-css']);

// js compressor
gulp.task('js', function () {
    gulp.src([ layoutsassRoot +'/js/*.js', themesassRoot + '/js/*.js', 'site/js/*.js'])
       // .pipe(compressor())
        .pipe(concat("final.js"))
        .pipe(gulp.dest('site/js/final'));
});

// css compressor
gulp.task('css', ['all-compass'], function () {
    gulp.src([layoutsassRoot +'/css/*.css', themesassRoot + '/css/*.css', 'site/css/*.css'])
        .pipe(compressor())
        .pipe(concat("final.css"))
        .pipe(gulp.dest('site/css/final'));
});

gulp.task('default', ['all-compass', 'js', 'css']);

//
// This runs the server. You have to have the "-o 0.0.0.0"
// for ruby to listen to all interfaces.
//
gulp.task('start', function() {
	run('ruby rubyPress.rb -o 0.0.0.0').exec()
    .pipe(gulp.dest('output'));
});
