﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Blueprinter.Core.Services
{
    public interface IContext
    {
        IEnumerable<BlueprintInfo> GetAllBlueprints();
        void SaveBlueprints(IEnumerable<BlueprintInfo> blueprints);

        IEnumerable<TemplateInfo> GetAllTemplates();
        void SaveTemplates(IEnumerable<TemplateInfo> templates);

        event EventHandler BlueprintsUpdated;


        void SaveBlueprint(BlueprintInfo bp);

        BlueprintNodeWriter CreateNodeWriter(string path);
    }
}
