﻿using Blueprinter.Core;
using Blueprinter.Presentation;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Blueprinter
{
    public partial class ViewMain : Form, IViewMain
    {
        private IViewMainPresenter _presenter;
        public IViewMainPresenter Presenter
        {
            get { return _presenter; }
            set
            {
                if (_presenter == null)
                {
                    _presenter = value;
                }
            }
        }

        public ViewMain()
        {
            InitializeComponent();
        }

        private void blueprintManagerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _presenter.RunBlueprintManager();
        }

        public void Run()
        {
            Application.Run(this);
        }

        private void contentManagerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _presenter.RunTemplateManager();
        }

        private IEnumerable<BlueprintInfo> _blueprints;
        public IEnumerable<BlueprintInfo> Blueprints
        {
            get
            {
                return _blueprints;
            }
            set
            {
                _blueprints = value;

                LoadComboBox();
            }
        }

        private void LoadComboBox()
        {
            BlueprintComboBox.Items.Clear();

            foreach (var bp in _blueprints)
            {
                BlueprintComboBox.Items.Add(bp);
                BlueprintComboBox.DisplayMember = "Name";
            }
        }

        public string ProjectPath
        {
            get { return BasePathTextBox.Text; }
        }

        public string ProjectBlueprint
        {
            get { return BlueprintTextBox.Text; }
        }

        private void BlueprintComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            var item = BlueprintComboBox.SelectedItem as BlueprintInfo;

            if (item == null)
            {
                return;
            }

            BlueprintTextBox.Text = item.Blueprint;
        }

        private void BrowseButton_Click(object sender, EventArgs e)
        {
            using (var frm = new FolderBrowserDialog())
            {
                if (frm.ShowDialog() == DialogResult.OK)
                {
                    BasePathTextBox.Text = frm.SelectedPath;
                }
            }
        }


        public BlueprintInfo SelectedBlueprint
        {
            get { return BlueprintComboBox.SelectedItem as BlueprintInfo; }
        }

        private void saveToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _presenter.SaveBlueprint();
        }

        private void saveAsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _presenter.SaveBlueprintAs();
        }
    }
}
