﻿using Blueprinter.Presentation;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Blueprinter
{
    public partial class ViewFileSaveAs : Form, IViewFileSaveAs
    {
        public ViewFileSaveAs()
        {
            InitializeComponent();
        }

        private void SaveButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Hide();

            _presenter.Save();
        }

        private void CancelButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Hide();
        }

        private IViewFileSaveAsPresenter _presenter;
        public IViewFileSaveAsPresenter Presenter
        {
            get { return _presenter; }
            set
            {
                if (_presenter == null)
                {
                    _presenter = value;
                }
            }
        }

        public void Run()
        {
            ShowDialog();
        }

        public string SelectedFileName
        {
            get { return NameTextBox.Text; }
        }
    }
}
