﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Blueprinter.Presentation
{
    public class ViewFileSaveAsPresenter : IViewFileSaveAsPresenter
    {
        private readonly IViewFileSaveAs _view;
        private readonly IApplicationController _appController;
        public ViewFileSaveAsPresenter(IViewFileSaveAs view, IApplicationController appController)
        {
            _view = view;
            _appController = appController;
            _view.Presenter = this;
        }

        public IViewFileSaveAs View
        {
            get
            {
                return _view;
            }
        }

        public void Run()
        {
            _view.Run();
        }

        public void Save()
        {
            var filename = _view.SelectedFileName;

            OnFileNameSelected(filename);
        }

        protected void OnFileNameSelected(string filename)
        {
            if (FileNameSelected != null)
            {
                FileNameSelected(this, filename);
            }
        }


        public event EventHandler<string> FileNameSelected;
    }
}
