﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Blueprinter.Presentation
{
    public class ViewMainPresenter : IViewMainPresenter
    {
        private readonly IViewMain _view;
        private readonly IApplicationController _appController;
        public ViewMainPresenter(IViewMain view, IApplicationController appController)
        {
            _view = view;
            _appController = appController;
            _view.Presenter = this;

            _appController.Context.BlueprintsUpdated += Context_BlueprintsUpdated;
        }

        void Context_BlueprintsUpdated(object sender, EventArgs e)
        {
            _view.Blueprints = _appController.Context.GetAllBlueprints();
        }

        public IViewMain View
        {
            get
            {
                return _view;
            }
        }

        public void Run()
        {
            Context_BlueprintsUpdated(null, null);
            _view.Run();
        }

        public void RunBlueprintManager()
        {
            _appController.RunBlueprintManager();
        }

        public void RunTemplateManager()
        {
            _appController.RunTemplateManager();
        }


        public void SaveBlueprint()
        {
            var bp = _view.SelectedBlueprint;
            var text = _view.ProjectBlueprint;

            if (bp == null)
            {
                SaveBlueprintAs(text);
            }

            bp.Blueprint = text;

            _appController.Context.SaveBlueprint(bp);
        }

        public void SaveBlueprintAs()
        {
            var text = _view.ProjectBlueprint;

            SaveBlueprintAs(text);

        }

        private void SaveBlueprintAs(string text)
        {

        }
    }
}
