﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Blueprinter.Presentation
{
    public class ViewBlueprintManagerPresenter : IViewBlueprintManagerPresenter
    {
        private readonly IViewBlueprintManager _view;
        private readonly IApplicationController _appController;
        public ViewBlueprintManagerPresenter(IViewBlueprintManager view, IApplicationController appController)
        {
            _view = view;
            _appController = appController;
            _view.Presenter = this;
        }

        public IViewBlueprintManager View
        {
            get
            {
                return _view;
            }
        }


        public void Run()
        {
            _view.Blueprints = _appController.Context.GetAllBlueprints();
            _view.Run();
        }

        public void Save()
        {
            var blueprints = _view.Blueprints;

            _appController.Context.SaveBlueprints(blueprints);
        }
    }
}
