﻿using Blueprinter.Core;
using Blueprinter.Presentation;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Blueprinter
{
    public partial class ViewBlueprintManager : Form, IViewBlueprintManager
    {
        private IViewBlueprintManagerPresenter _presenter;
        private readonly BindingSource _data = new BindingSource();
        public ViewBlueprintManager()
        {
            InitializeComponent();
        }

        public IViewBlueprintManagerPresenter Presenter
        {
            get
            {
                return _presenter;
            }
            set
            {
                if (_presenter == null)
                {
                    _presenter = value;
                }
            }
        }


        public void Run()
        {
            NameTextBox.Bind(_data, "Name");
            ContextTextBox.Bind(_data, "Blueprint");

            BlueprintListBox.DataSource = _data;
            BlueprintListBox.DisplayMember = "Name";

            ShowDialog();
        }

        public IEnumerable<BlueprintInfo> Blueprints
        {
            get
            {
                return _data.List.Cast<BlueprintInfo>();
            }
            set
            {
                _data.DataSource = value.ToList();
            }
        }

        private void AddButton_Click(object sender, EventArgs e)
        {
            var blueprint = new BlueprintInfo
            {
                Name = "New Blueprint"
            };

            _data.Add(blueprint);

            BlueprintListBox.SelectedIndex = BlueprintListBox.Items.Count - 1;
        }

        private void RemoveButton_Click(object sender, EventArgs e)
        {
            var index = BlueprintListBox.SelectedIndex;

            if (index < 0)
            {
                return;
            }

            _data.RemoveAt(index);
        }

        private void ViewBlueprintManager_FormClosing(object sender, FormClosingEventArgs e)
        {
            label1.Focus();
            _presenter.Save();
        }
    }
}
