﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Blueprinter.Core.Data
{
    public class BlueprintInfoRepository : XmlRepository<BlueprintInfo>
    {
        public override BlueprintInfo Create(BlueprintInfo t)
        {
            if (t.Id == new Guid())
            {
                throw new Exception("Blueprint ID already exists.");
            }

            t.Id = Guid.NewGuid();
            t.LastModified = DateTime.Now;

            Records.Add(t);

            WriteFile();

            return t;
        }

        public override int Delete(BlueprintInfo t)
        {
            var record = Records.SingleOrDefault(r => r.Id == t.Id);

            if (record == null)
            {
                return 0;
            }

            Records.Remove(record);

            WriteFile();

            return 1;
        }

        public override int Update(BlueprintInfo t)
        {
            var record = Records.SingleOrDefault(r => r.Id == t.Id);

            if (record == null)
            {
                return 0;
            }

            record.Name = t.Name;
            record.Blueprint = t.Blueprint;
            record.LastModified = DateTime.Now;

            WriteFile();

            return 1;
        }
    }
}
