﻿using EventDrivenCommunication.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EventDrivenCommunication
{
    public partial class ManagePersonForm : Form, IManagePersonForm
    {
        private Person _person;

        public ManagePersonForm()
        {
            InitializeComponent();
        }

        public event EventHandler PersonSaved;

        public Person Person
        {
            get
            {
                return _person;
            }
            set
            {
                _person = value;

                FirstNameTextBox.Text = _person.FirstName;
                LastNameTextBox.Text = _person.LastName;
            }
        }

        protected void OnPersonSaved()
        {
            if (PersonSaved != null)
            {
                PersonSaved(this, EventArgs.Empty);
            }
        }

        private void OkButton_Click(object sender, EventArgs e)
        {
            _person.FirstName = FirstNameTextBox.Text;
            _person.LastName = LastNameTextBox.Text;

            OnPersonSaved();
        }
    }
}
