//
//  ViewController.m
//  FlickrBrowser
//
//  Created by Marin Todorov on 2/23/14.
//  Copyright (c) 2014 Tuts+. All rights reserved.
//

#import "ViewController.h"

#import "ImageCell.h"
#import "PublicPhotosModel.h"
#import "UIImageView+WebCache.h"

@interface ViewController ()

@property (strong, nonatomic) PublicPhotosModel *photosModel;

@end

@implementation ViewController

#pragma mark -
#pragma mark View Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Fetch Photos
    [self fetchPhotos];
}

#pragma mark -
#pragma mark Table View Data Source Methods
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.photosModel.items.count;
}

- (NSString*)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.dateStyle = NSDateFormatterMediumStyle;
    formatter.timeStyle = NSDateFormatterMediumStyle;
    return [formatter stringFromDate: self.photosModel.modified];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *const cellId = @"ImageCell";
    
    ImageCell *cell = [self.tableView dequeueReusableCellWithIdentifier: cellId];
    
    if (!cell) {
        cell = [[ImageCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier: cellId];
    }
    
    // cell.textLabel.text = [@(indexPath.row) stringValue];
    
    PhotoModel *photo = self.photosModel.items[indexPath.row];
    
    cell.textLabel.text = photo.title;
    cell.detailTextLabel.text = [photo.tags.tags componentsJoinedByString:@", "];
    [cell.webImageView setImageWithURL:photo.url placeholderImage:nil];
    
    return cell;
}

#pragma mark -
#pragma mark Table View Delegate Methods
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [self.tableView deselectRowAtIndexPath: indexPath animated:YES];
    
    PhotoModel *photo = self.photosModel.items[indexPath.row];
    
    if ([[UIApplication sharedApplication] canOpenURL:photo.link]) {
        [[UIApplication sharedApplication] openURL:photo.link];
    }
}

#pragma mark -
#pragma mark Helper Methods
- (void)fetchPhotos {
    NSURL *photosURL = [NSURL URLWithString:@"http://api.flickr.com/services/feeds/photos_public.gne?id=46760712@N07&lang=en-us&format=json&nojsoncallback=1"];
    
    [[[NSURLSession sharedSession] dataTaskWithURL:photosURL completionHandler:^(NSData *data, NSURLResponse *response, NSError *error) {
        NSString* rawJSON = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
        rawJSON = [rawJSON stringByReplacingOccurrencesOfString:@"\\'" withString:@"'"];
        
        // self.photosModel = [[PublicPhotosModel alloc] initWithString:rawJSON error:nil];
        
        NSError *err;
        self.photosModel = [[PublicPhotosModel alloc] initWithString:rawJSON error:&err];
        
        if (err) {
            NSLog(@"Unable to initialize PublicPhotosModel, %@", err.localizedDescription);
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            self.title = self.photosModel.title;
            [self.tableView reloadData];
        });
    }] resume];
}

@end
