//
//  ViewController.m
//  HelloChuck
//
//  Created by Marin Todorov on 01/03/14.
//  Copyright (c) 2014 Tuts+. All rights reserved.
//

#import "ViewController.h"

#import "JokeModel.h"

@interface ViewController ()

@property (strong, nonatomic) UILabel* label;
@property (strong, nonatomic) NSArray* jokes;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.label = [[UILabel alloc] initWithFrame:self.view.bounds];
    self.label.numberOfLines = 0;
    self.label.textAlignment = NSTextAlignmentCenter;
    self.label.alpha = 0;
    
    [self.view addSubview: self.label];
    
    [self fetchJokes];
}

- (void)fetchJokes {
    NSURL* jokesUrl = [NSURL URLWithString:@"https://s3.amazonaws.com/com.tuts.mobile/jokes.json"];
    
    [[[NSURLSession sharedSession] dataTaskWithURL:jokesUrl completionHandler:^(NSData *data, NSURLResponse *response, NSError *error) {
        self.jokes = [JokeModel arrayOfModelsFromData:data error:nil];
        
        dispatch_async(dispatch_get_main_queue(), ^{
            [self showNextJoke];
        });
    }] resume];
}

- (void)showNextJoke {
    JokeModel* model = self.jokes[arc4random() % self.jokes.count];
    
    NSString* tags = model.tags?[model.tags componentsJoinedByString:@","]:@"no tags";
    self.label.text = [NSString stringWithFormat:@"%i. %@\n\n%@", model.id, model.text, tags];
    
    [UIView animateWithDuration:1.0 animations:^{
        self.label.alpha = 1.0;
    } completion:^(BOOL finished) {
        [self performSelector:@selector(hideJoke) withObject:nil afterDelay:5.0];
    }];
}

- (void)hideJoke {
    [UIView animateWithDuration:1.0 animations:^{
        self.label.alpha = 0.0;
    } completion:^(BOOL finished) {
        [self showNextJoke];
    }];
}

@end
