//
//  main.m
//  Foundation
//
//  Created by Bart Jacobs on 23/03/14.
//  Copyright (c) 2014 Tuts+. All rights reserved.
//

#import <Foundation/Foundation.h>

int main(int argc, const char * argv[])
{
    
    @autoreleasepool {
        
        // insert code here...
        
        // NSObject
        NSObject *myFirstObject = [[NSObject alloc] init];
        NSLog(@"Class > %@", [myFirstObject class]);
        NSLog(@"Superclass > %@", [myFirstObject superclass]);
        NSLog(@"Conforms to Protocol > %i", [myFirstObject conformsToProtocol:@protocol(NSObject)]);
        
        // NSNumber
        NSNumber *myNumber = [NSNumber numberWithDouble:854736e+16];
        NSLog(@"Double Value    > %f", [myNumber doubleValue]);
        NSLog(@"Float Value     > %f", [myNumber floatValue]);
        NSLog(@"Int Value       > %i", [myNumber intValue]);
        
        // NSString
        NSString *string1 = @"This is a string literal.";
        NSString *string2 = [[NSString alloc] initWithFormat:@"Strings can be created many ways."];
        NSMutableString *mutableString = [[NSMutableString alloc] initWithString:string1];
        [mutableString appendFormat:@" %@", string2];
        NSLog(@"%@", mutableString);
        
        // NSArray
        NSArray *myArray = [NSArray arrayWithObjects:@"Bread", @"Butter", @"Milk", @"Eggs", nil];
        NSLog(@"Number of Elements  > %li", [myArray count]);
        NSLog(@"Object at Index 2   > %@", [myArray objectAtIndex:2]);
        
        // NSMutableArray
        NSMutableArray *myMutableArray = [NSMutableArray arrayWithObject:[NSNumber numberWithInt:265]];
        [myMutableArray addObject:[NSNumber numberWithInt:45]];
        NSLog(@"Mutable Array       > %@", myMutableArray);
        
        // NSDictionary
        NSString *keyA = @"myKey";
        NSString *keyB = @"myKey";
        NSDictionary *myDictionary = [NSDictionary dictionaryWithObject:@"This is a string literal" forKey:keyA];
        NSLog(@"%@", [myDictionary objectForKey:keyB]);
        
        // NSMutableDictionary
        NSMutableDictionary *myMutableDictionary = [NSMutableDictionary dictionary];
        [myMutableDictionary setObject:myDictionary forKey:@"myDictionary"];
        NSLog(@"%@", myMutableDictionary);
        
        // NSLog
        NSLog(@"%@ - %i - %f", @"an object", 3, 3.14);
    }
    
    return 0;
}
