<?php
/**
 * Plugin Name: Tuts+ Related Posts
 * Plugin URI: http://code.tutsplus.com/tutorials/creating-a-list-of-posts-with-the-same-categories-as-the-current-one--cms-22626
 * Description: This plugin identifies what categories the current post is in and outputs a list of the most recent posts in the same categories.
 * Version: 1.0.0
 * Author: Rachel McCollin
 * Author URI: http://rachelmccollin.com
 * License: GPL-3.0+
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Domain Path: /lang
 * Text Domain: tutsplus
 */

function tutsplus_related_posts() {

    $post_id = get_the_ID();
    $cat_ids = array();
    $categories = get_the_category( $post_id );

    if ( $categories && !is_wp_error( $categories ) ) {

        foreach ( $categories as $category ) {

            array_push( $cat_ids, $category->term_id );

        }

    }

    $current_post_type = get_post_type( $post_id );
    
    $args = array(
        'category__in' => $cat_ids,
        'post_type' => $current_post_type,
        'posts_per_page' => '5',
        'post__not_in' => array( $post_id )
    );
    
    $query = new WP_Query( $args );

    if ( $query->have_posts() ) {

        ?>
        <aside class="related-posts">
            <h3>
                <?php _e( 'Related Posts', 'tutsplus' ); ?>
            </h3>
            <ul class="related-posts">
                <?php

                    while ( $query->have_posts() ) {

                        $query->the_post();

                        ?>
                        <li>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_title(); ?>
                            </a>
                        </li>
                        <?php

                    }

                ?>
            </ul>
        </aside>
        <?php

    }

    wp_reset_postdata();
    
}