<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the
 * plugin admin area. This file also includes all of the dependencies used by
 * the plugin, and defines a function that starts the plugin.
 *
 * @link              http://code.tutsplus.com/tutorials/adding-custom-fields-to-simple-products-with-woocommerce--cms-27904
 * @package           CWF
 *
 * @wordpress-plugin
 * Plugin Name:       Tuts+ Custom WooCommerce Field
 * Plugin URI:        http://code.tutsplus.com/tutorials/adding-custom-fields-to-simple-products-with-woocommerce--cms-27904
 * Description:       Demonstrates how to add a custom field to a Simple Product.
 * Version:           1.0.0
 * Author:            Tom McFarlin
 * Author URI:        https://tommcfarlin.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

defined( 'WPINC' ) || die;

include_once 'admin/class-tutsplus-custom-woocommerce-field.php';
include_once 'public/class-tutsplus-custom-woocommerce-display.php';

add_action( 'plugins_loaded', 'tutsplus_wc_input_start' );
/**
 * Start the plugin.
 */
function tutsplus_wc_input_start() {

	if ( is_admin() ) {

		$admin = new TutsPlus_Custom_WooCommerce_Field( 'tutsplus_text_field' );
		$admin->init();
	} else {

		$plugin = new TutsPlus_Custom_WooCommerce_Display( 'tutsplus_text_field' );
		$plugin->init();
	}
}