<?php
/**
 * Demonstrates how to display the custom desription provided in the 'Linked Attributes'
 * of the Simple Produt.
 *
 * @package CWF\Public
 */

/**
 * Demonstrates how to display the custom desription provided in the 'Linked Attributes'
 * of the Simple Produt.
 *
 * This plugin is a demo for a corresponding Tuts+ tutorial.
 *
 * @package CWF\Public
 */
class TutsPlus_Custom_WooCommerce_Display {

	/**
	 * Maintains a value to the text field ID for serialization.
	 *
	 * @access private
	 * @var    string
	 */
	private $textfield_id;

	/**
	 * Initializes the class and the instance variables.
	 */
	public function __construct( $id ) {
		$this->textfield_id = $id;
	}

	/**
	 * Registers hooks for displaying data on the front-end of the site.
	 */
	public function init() {

		add_action(
			'woocommerce_product_thumbnails',
			array( $this, 'product_thumbnails' )
		);
	}

	/**
	 * Retrieves the metadata and echos it just below the product thumbnail.
	 */
	public function product_thumbnails() {

		$teaser = get_post_meta( get_the_ID(), $this->textfield_id, true );
		if ( empty( $teaser ) ) {
			return;
		}

		echo esc_html( $teaser );
	}
}