<?php
/**
 * Demonstrates how to add a custom field to the 'Linked Products' tab of a
 * Simple Product in WooCommerce.
 *
 * @package CWF\Admin
 */

/**
 * Demonstrates how to add a custom field to the 'Linked Products' tab of a
 * Simple Product in WooCommerce.
 *
 * This plugin is a demo for a corresponding Tuts+ tutorial.
 *
 * @package CWF\Admin
 */
class TutsPlus_Custom_WooCommerce_Field {

	/**
	 * Maintains a value to the text field ID for serialization.
	 *
	 * @access private
	 * @var    string
	 */
	private $textfield_id;

	/**
	 * Initializes the class and the instance variables.
	 */
	public function __construct( $id ) {
		$this->textfield_id = $id;
	}

	/**
	 * Initializes the hooks for adding the text field and saving the values.
	 */
	public function init() {

		add_action(
			'woocommerce_product_options_grouping',
			array( $this, 'product_options_grouping' )
		);

		add_action(
			'woocommerce_process_product_meta',
			array( $this, 'add_custom_linked_field_save' )
		);
	}

	/**
	 * Initializes and renders the contents of the text field.
	 */
	public function product_options_grouping() {

		$description = sanitize_text_field(
			'Enter a description that will be displayed for those who are
			viewing the product.'
		);

		$placeholder = sanitize_text_field(
			'Tease your product with a short description.'
		);

		$args = array(
			'id' 			=> $this->textfield_id,
			'label'			=> sanitize_text_field( 'Product Teaser' ),
			'placeholder'	=> $placeholder,
			'desc_tip'		=> true,
			'description'	=> $description,
		);
		woocommerce_wp_text_input( $args );
	}

	/**
	 * Saves a sanitized version of the VHX Package ID values provided by the user.
	 *
	 * @param int $post_id The ID of the current post to which the IDs are associated.
	 */
	public function add_custom_linked_field_save( $post_id ) {

		if ( ! ( isset( $_POST['woocommerce_meta_nonce'], $_POST[ $this->textfield_id ] ) || wp_verify_nonce( sanitize_key( $_POST['woocommerce_meta_nonce'] ), 'woocommerce_save_data' ) ) ) { // Input var okay.
			return false;
		}

		$product_teaser = sanitize_text_field(
			wp_unslash( $_POST[ $this->textfield_id ] ) // Input var okay.
		);

		update_post_meta(
			$post_id,
			$this->textfield_id,
			esc_attr( $product_teaser )
		);
	}
}