<?php
/**
 * The plugin bootstrap File_Upload_Upgrader::cleanup
 *
 * @link              http://code.tutsplus.com/tutorials/internationalizing-wordpress-projects-a-practical-example-part-1--cms-26676
 * @since             1.0.0
 * @package           TutsPlus_i18n
 *
 * @wordpress-plugin
 * Plugin Name:       Tuts+ Internationalization
 * Plugin URI:        http://code.tutsplus.com/tutorials/internationalizing-wordpress-projects-a-practical-example-part-1--cms-26676
 * Description:       Easily view internationalized server information.
 * Version:           1.0.0
 * Author:            Tom McFarlin
 * Author URI:        https://tommcfarlin.com
 * Text Domain:       tutsplus-i18n
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

add_action( 'admin_menu', 'tutsplus_i18n_add_submenu_page' );
/**
 * Adds a new submenu item to the Tools menu that will display server
 * information to the user.
 *
 * The menu item is internationalized so that we can provide proper translations
 * for users who are outside of our own locale.
 */
function tutsplus_i18n_add_submenu_page() {

	add_submenu_page(
		'tools.php',
		__( 'Server Information', 'tutsplus-i18n' ),
		__( 'Server Information', 'tutsplus-i18n' ),
		'manage_options',
		'tutsplus-i18n-menu',
		'tutsplus_i18n_display_submenu_page'
	);

}

/**
 * Displays the content of the page associated with the new Server Information
 * menu item located in the Tools menu.
 */
function tutsplus_i18n_display_submenu_page() {
	include_once( 'tutsplus-i18n-ui.php' );
}

add_action( 'admin_enqueue_scripts', 'tutsplus_i18n_dashboard_styles' );
/**
 * Add styles to the table displayed in the Server Info page available from the
 * Tools menu.
 */
function tutsplus_i18n_dashboard_styles() {

	// Only register the stylesheet if we're on the Server Information page.
	if ( 'tools_page_tutsplus-i18n-menu' !== get_current_screen()->id ) {
		return;
	}

	wp_enqueue_style(
		'tutsplus-i18n-css',
		plugin_dir_url( __FILE__ ) . '/tutsplus-i18n.css',
		array(),
		'1.0.0',
		'all'
	);

}
