<?php
/**
 * The user interface for the plugin.
 *
 * @link              http://code.tutsplus.com/tutorials/internationalizing-wordpress-projects-a-practical-example-part-1--cms-26676
 * @since             1.0.0
 * @package           TutsPlus_i18n
 */

?>

<div class="wrap">

	<h1><?php esc_html_e( 'Server Information', 'tutsplus-i18n' ); ?></h1>
	<span class="description"><?php esc_html_e( 'Information about the environment in which WordPress is running.', 'tutsplus-i18n' ); ?></span>

	<table id="tutsplus-i18n-table">
		<thead>
			<tr>
				<td>
					<strong><?php esc_html_e( 'Server Key', 'tutsplus-i18n' ); ?></strong>
				</td>
				<td>
					<strong><?php esc_html_e( 'Server Value', 'tutsplus-i18n' ); ?></strong>
				</td>
			</tr>
		</thead>
		<tbody>

			<?php // This counter is used to determine even/odd rows for styles. ?>
			<?php $i = 0; ?>

			<?php foreach ( $_SERVER as $key => $val ) { // Input var okay. ?>

				<?php // Determine if we're on an odd or even row. ?>
				<?php $striped = ( $i % 2 ) ? 'even' : 'odd'; ?>

				<tr class="<?php esc_attr_e( $striped ); ?>">
					<td>
						<?php esc_html_e( $key ) ; ?>
					</td>
					<td>
						<?php esc_html_e( $val ); ?>
					</td>
				</tr>

				<?php // Increase the counter by one. ?>
				<?php $i++; ?>

			<?php } ?>
		</tbody>
	</table>

</div>
