﻿using UnityEngine;
using System.Collections;

public class Game : MonoBehaviour
{

    public Camera gameCamera;
    public Bot player;
    bool[] inputs;
    bool[] prevInputs;

    int lastMouseTileX = -1;
    int lastMouseTileY = -1;

    public KeyCode goLeftKey = KeyCode.A;
    public KeyCode goRightKey = KeyCode.D;
    public KeyCode goJumpKey = KeyCode.W;
    public KeyCode goDownKey = KeyCode.S;

    public const int cLedgeGrabStopFrames = 5;
    public int mLedgeGrabStopFrames = 0;

    public Map mMap;

    public TileType mPlacedTileType;

    void Start ()
    {
        inputs = new bool[(int)KeyInput.Count];
        prevInputs = new bool[(int)KeyInput.Count];

        mMap.Init();

        player.BotInit(inputs, prevInputs);
        player.mMap = mMap;
        player.mGame = this;
    }
	
	void Update ()
    {
        inputs[(int)KeyInput.GoRight] = Input.GetKey(goRightKey);
        inputs[(int)KeyInput.GoLeft] = Input.GetKey(goLeftKey);
        inputs[(int)KeyInput.GoDown] = Input.GetKey(goDownKey);
        inputs[(int)KeyInput.Jump] = Input.GetKey(goJumpKey);

        if (Input.GetKeyUp(KeyCode.Mouse0))
            lastMouseTileX = lastMouseTileY = -1;

        Vector2 mousePos = Input.mousePosition;
        Vector2 cameraPos = Camera.main.transform.position;
        var mousePosInWorld = cameraPos + mousePos - new Vector2(gameCamera.pixelWidth / 2, gameCamera.pixelHeight / 2);

        int mouseTileX, mouseTileY;
        mMap.GetMapTileAtPoint(mousePosInWorld, out mouseTileX, out mouseTileY);

        Vector2 offsetMouse = (Vector2)(Input.mousePosition) - new Vector2(Camera.main.pixelWidth / 2, Camera.main.pixelHeight / 2);
        Vector2 bottomLeft = (Vector2)mMap.sliderLow.position + mMap.sliderLow.rect.min;
        Vector2 topRight = (Vector2)mMap.sliderHigh.position + mMap.sliderHigh.rect.max;

        if (Input.GetKeyDown(KeyCode.Tab))
            Debug.Break();

        //Debug.Log(mousePos + "   " + bottomLeft + "     " + topRight);

        if (mousePos.x > bottomLeft.x && mousePos.x < topRight.x && mousePos.y < topRight.y && mousePos.y > bottomLeft.y)
            return;

        if (Input.GetKeyDown(KeyCode.Mouse0))
        {
            //player.TappedOnTile(new Vector2i(mouseTileX, mouseTileY));
            //Debug.Log(mouseTileX + "  " + mouseTileY);
        }

        if (Input.GetKey(KeyCode.Mouse1) || Input.GetKey(KeyCode.Mouse2))
        {
            if (mouseTileX != lastMouseTileX || mouseTileY != lastMouseTileY || Input.GetKeyDown(KeyCode.Mouse1) || Input.GetKeyDown(KeyCode.Mouse2))
            {
                if (!mMap.IsNotEmpty(mouseTileX, mouseTileY))
                    mMap.SetTile(mouseTileX, mouseTileY, Input.GetKey(KeyCode.Mouse1) ? mPlacedTileType : TileType.OneWay);
                else
                    mMap.SetTile(mouseTileX, mouseTileY, TileType.Empty);

                lastMouseTileX = mouseTileX;
                lastMouseTileY = mouseTileY;

                Debug.Log(mouseTileX + "  " + mouseTileY);
            }
        }
    }

    void FixedUpdate()
    {
        if (mLedgeGrabStopFrames > 0)
        {
            --mLedgeGrabStopFrames;
            return;
        }

        player.BotUpdate();
    }
}
