﻿using UnityEngine;
using System.Collections;

public class Game : MonoBehaviour
{

    public Camera gameCamera;
    public Character player;
    bool[] inputs;
    bool[] prevInputs;

    public KeyCode goLeftKey = KeyCode.A;
    public KeyCode goRightKey = KeyCode.D;
    public KeyCode goJumpKey = KeyCode.W;
    public KeyCode goDownKey = KeyCode.S;

    void Start ()
    {
        inputs = new bool[(int)KeyInput.Count];
        prevInputs = new bool[(int)KeyInput.Count];


        player.CharacterInit(inputs, prevInputs);
        player.mGame = this;
    }
	
	void Update ()
    {
        inputs[(int)KeyInput.GoRight] = Input.GetKey(goRightKey);
        inputs[(int)KeyInput.GoLeft] = Input.GetKey(goLeftKey);
        inputs[(int)KeyInput.GoDown] = Input.GetKey(goDownKey);
        inputs[(int)KeyInput.Jump] = Input.GetKey(goJumpKey);

        player.CharacterUpdate();
    }

    /*void FixedUpdate()
    {
        player.CharacterUpdate();
    }*/
}
