<?php
/**********************************************************************************
 theme to support tuts+ tutorial on using a CPT for sidebars - functions file
**********************************************************************************/

/**********************************************************************************
 register a post type for sidebars
**********************************************************************************/
function tutsplus_create_sidebar_post_type() {
	$labels = array( 
		'name' => __( 'Sidebars' ),
		'singular_name' => __( 'Sidebar' ),
		'add_new' => __( 'New Sidebar' ),
		'add_new_item' => __( 'Add New Sidebar' ),
		'edit_item' => __( 'Edit Sidebar' ),
		'new_item' => __( 'New Sidebar' ),
		'view_item' => __( 'View Sidebar' ),
		'search_items' => __( 'Search Sidebars' ),
		'not_found' =>  __( 'No Sidebars Found' ),
		'not_found_in_trash' => __( 'No Sidebars found in Trash' ),
	);
	$args = array(
		'labels' => $labels,
		'has_archive' => false,
		'public' => true,
		'hierarchical' => false,
		'supports' => array(
			'title', 
			'editor', 
			'excerpt', 
			'custom-fields', 
			'thumbnail',
			'page-attributes'
		),
	);
	register_post_type( 'sidebar_post', $args );
} 
add_action( 'init', 'tutsplus_create_sidebar_post_type' );

/**********************************************************************************
 function to display sidebar posts - uses WP_Query
**********************************************************************************/
function tutsplus_sidebars() {
	
	$args = array(
		'post_type' => 'sidebar_post'
	);
	
	$query = new WP_query ( $args );
	if ( $query->have_posts() ) { ?>

		<?php while ( $query->have_posts() ) : $query->the_post(); /* start the loop */ ?>
	 
		<aside id="post-<?php the_ID(); ?>" <?php post_class( 'sidebar-post' ); ?>>
			<h3 class="sidebar-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'compass' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
	 
			<?php if ( has_post_thumbnail() ) { ?>
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( 'medium', array(
						'class' => 'aligncenter',
						'alt'	=> trim(strip_tags( $wp_postmeta->_wp_attachment_image_alt ))
					) ); ?>
				</a>
			<?php } ?>
			
			<section class="sidebar-content">
				<?php the_content(); ?>
			</section><!-- .entry-content -->
			
		</aside>
	 
		<?php endwhile; /* end the loop*/ ?>
	 
		<?php rewind_posts();
	}
}

/**********************************************************************************
 function to unregister twenty fifteen sidebar widget area
**********************************************************************************/
function tutsplus_unregister_sidebar_widget_area() {
	unregister_sidebar( 'sidebar-1' );
}
add_action( 'widgets_init', 'tutsplus_unregister_sidebar_widget_area', 15 );