<?php 
/*Plugin Name: List Subpages Widget
Description: This widget checks if the current page has parent or child pages and if so, outputs a list of the highest ancestor page and its descendants. This file supports part 4 of the series to create the widget and doesn't give you a functioning widget.
Version: 0.4
Author: Rachel McCollin
Author URI: http://rachelmccollin.com
License: GPLv2
*/
?>
<?php
/*******************************************************************************
class Tutsplus_List_Pages_Widget. Extends the WP_Widget constructor class
*******************************************************************************/
?>
<?php
class Tutsplus_List_Pages_Widget extends WP_Widget {
	
	function __construct() {
	
		parent::__construct(
			
			// base ID of the widget
			'tutsplus_list_pages_widget',
			
			// name of the widget
			__('List Related Pages', 'tutsplus' ),
			
			// widget options
			array (
				'description' => __( 'Identifies where the current page is in the site structure and displays a list of pages in the same section of the site. Only works on Pages.', 'tutsplus' )
			)
			
		);
		
	}
	
	function form( $instance ) {
	
		$defaults = array(
			'depth' => '-1'
		);
		$depth = $instance[ 'depth' ];
		
		// markup for form ?>
		<p>
			<label for="<?php echo $this->get_field_id( 'depth' ); ?>">Depth of list:</label>
			<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'depth' ); ?>" name="<?php echo $this->get_field_name( 'depth' ); ?>" value="<?php echo esc_attr( $depth ); ?>">
		</p>
				
	<?php
	}
	
	function update( $new_instance, $old_instance ) {
	
		$instance = $old_instance;
		$instance[ 'depth' ] = strip_tags( $new_instance[ 'depth' ] );
		return $instance;
		
	}
	
	function widget( $args, $instance ) {
		
	}
	
}
?>
<?php
/*******************************************************************************
function tutsplus_register_list_pages_widget() - registers the widget.
*******************************************************************************/
?>
<?php
function tutsplus_register_list_pages_widget() {

	register_widget( 'Tutsplus_List_Pages_Widget' );

}
add_action( 'widgets_init', 'tutsplus_register_list_pages_widget' );
?>