<?php
/**
 * The template for displaying the footer.
 *
 * Contains the footer element and all content
 * after. 
 *
 */
?>


<footer>

	<?php
	/*the footer widget areas.
	The footer widget areas use is_active_sidebar() to check how many widget areas have widgets within them 
	and adjust the layout accordingly.
	If there are four widget areas with content, each will take up a quarter of a width in desktop,
	if there are three, each will take up a third of the width etc.
	For this reason, it is essential to use the widget areas in order when populating them and only keep the later ones empty.
	*/
	
	/* The footer widget area is triggered if any of the areas
	 * have widgets. So let's check that first.
	 *
	 * If none of the sidebars have widgets, then let's bail early.
	 */
	if (   ! is_active_sidebar( 'first-footer-widget-area'  )
		&& ! is_active_sidebar( 'second-footer-widget-area' )
		&& ! is_active_sidebar( 'third-footer-widget-area'  )
		&& ! is_active_sidebar( 'fourth-footer-widget-area' )
	)
		return;
		
		
	// If we get this far, we have widgets.
	// The next check is to see if all four widget areas have content, which will affect the CSS classes used.
	if (   is_active_sidebar( 'first-footer-widget-area'  )
		&& is_active_sidebar( 'second-footer-widget-area' )
		&& is_active_sidebar( 'third-footer-widget-area'  )
		&& is_active_sidebar( 'fourth-footer-widget-area' )
	) :	?>
	
	<aside class="fatfooter" role="complementary">
		<div class="first quarter left widget-area">
			<?php dynamic_sidebar( 'first-footer-widget-area' ); ?>
		</div><!-- .first .widget-area -->
	
		<div class="second quarter widget-area">
			<?php dynamic_sidebar( 'second-footer-widget-area' ); ?>
		</div><!-- .second .widget-area -->
	
		<div class="third quarter widget-area">
			<?php dynamic_sidebar( 'third-footer-widget-area' ); ?>
		</div><!-- .third .widget-area -->
	
		<div class="fourth quarter right widget-area">
			<?php dynamic_sidebar( 'fourth-footer-widget-area' ); ?>
		</div><!-- .fourth .widget-area -->
	</aside><!-- #fatfooter -->
	
	
	<?php 
	//end of check for all four sidebars. Next we check if there are three sidebars with widgets.
	elseif ( is_active_sidebar( 'first-footer-widget-area'  )
		&& is_active_sidebar( 'second-footer-widget-area' )
		&& is_active_sidebar( 'third-footer-widget-area'  )
		&& ! is_active_sidebar( 'fourth-footer-widget-area' )
	) : ?>
	<aside class="fatfooter" role="complementary">
		<div class="first one-third left widget-area">
			<?php dynamic_sidebar( 'first-footer-widget-area' ); ?>
		</div><!-- .first .widget-area -->
	
		<div class="second one-third widget-area">
			<?php dynamic_sidebar( 'second-footer-widget-area' ); ?>
		</div><!-- .second .widget-area -->
	
		<div class="third one-third right widget-area">
			<?php dynamic_sidebar( 'third-footer-widget-area' ); ?>
		</div><!-- .third .widget-area -->
	
	</aside><!-- #fatfooter -->
	
	
	<?php
	//end of check for three sidebars. Next we check if there are two sidebars with widgets.
	elseif ( is_active_sidebar( 'first-footer-widget-area'  )
		&& is_active_sidebar( 'second-footer-widget-area' )
		&& ! is_active_sidebar( 'third-footer-widget-area'  )
		&& ! is_active_sidebar( 'fourth-footer-widget-area' )
	) : ?>
	<aside class="fatfooter" role="complementary">
		<div class="first half left widget-area">
			<?php dynamic_sidebar( 'first-footer-widget-area' ); ?>
		</div><!-- .first .widget-area -->
	
		<div class="second half right widget-area">
			<?php dynamic_sidebar( 'second-footer-widget-area' ); ?>
		</div><!-- .second .widget-area -->
	
	</aside><!-- #fatfooter -->
	
	
	<?php
	//end of check for two sidebars. Finally we check if there is just one sidebar with widgets.
	elseif ( is_active_sidebar( 'first-footer-widget-area'  )
		&& ! is_active_sidebar( 'second-footer-widget-area' )
		&& ! is_active_sidebar( 'third-footer-widget-area'  )
		&& ! is_active_sidebar( 'fourth-footer-widget-area' )
	) :
	?>
	<aside class="fatfooter" role="complementary">
		<div class="first full-width widget-area">
			<?php dynamic_sidebar( 'first-footer-widget-area' ); ?>
		</div><!-- .first .widget-area -->
	
	</aside><!-- #fatfooter -->
	
	
	<?php 
	//end of all sidebar checks.
	endif;?>
		
</footer>

<?php

	/* Always have wp_footer() just before the closing </body>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to reference JavaScript files.
	 */

	wp_footer();
?>
</body>
</html>
